/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.managers;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.database.Database;
import world.bentobox.bentobox.database.objects.Ranks;

public class RanksManager {
    public static final String ADMIN_RANK_REF = "ranks.admin";
    public static final String MOD_RANK_REF = "ranks.mod";
    public static final String OWNER_RANK_REF = "ranks.owner";
    public static final String SUB_OWNER_RANK_REF = "ranks.sub-owner";
    public static final String MEMBER_RANK_REF = "ranks.member";
    public static final String TRUSTED_RANK_REF = "ranks.trusted";
    public static final String COOP_RANK_REF = "ranks.coop";
    public static final String VISITOR_RANK_REF = "ranks.visitor";
    public static final String BANNED_RANK_REF = "ranks.banned";
    public static final int ADMIN_RANK = 10000;
    public static final int MOD_RANK = 5000;
    public static final int OWNER_RANK = 1000;
    public static final int SUB_OWNER_RANK = 900;
    public static final int MEMBER_RANK = 500;
    public static final int TRUSTED_RANK = 400;
    public static final int COOP_RANK = 200;
    public static final int VISITOR_RANK = 0;
    public static final int BANNED_RANK = -1;
    private static LinkedHashMap<String, Integer> ranks = new LinkedHashMap();
    public static final Map<String, Integer> DEFAULT_RANKS = Map.of("ranks.admin", 10000, "ranks.mod", 5000, "ranks.owner", 1000, "ranks.sub-owner", 900, "ranks.member", 500, "ranks.trusted", 400, "ranks.coop", 200, "ranks.visitor", 0, "ranks.banned", -1);
    private static @NonNull Database<Ranks> handler;
    private static RanksManager instance;

    private RanksManager() {
        handler = new Database<Ranks>(BentoBox.getInstance(), Ranks.class);
        ranks = new LinkedHashMap();
        this.loadRanksFromDatabase();
    }

    public static synchronized RanksManager getInstance() {
        if (instance == null) {
            instance = new RanksManager();
        }
        return instance;
    }

    public void loadRanksFromDatabase() {
        handler = new Database<Ranks>(BentoBox.getInstance(), Ranks.class);
        if (!handler.objectExists("BentoBox-Ranks")) {
            DEFAULT_RANKS.forEach(this::ranksPut);
            this.save();
        } else {
            Objects.requireNonNull(handler.loadObject("BentoBox-Ranks")).getRankReference().forEach(this::ranksPut);
        }
    }

    private void save() {
        handler.saveObject(new Ranks(ranks));
    }

    public boolean rankExists(String reference) {
        return ranks.containsKey(reference);
    }

    public boolean addRank(String reference, int value) {
        if (this.rankExists(reference)) {
            return false;
        }
        this.ranksPut(reference, value);
        return true;
    }

    private void ranksPut(String reference, int value) {
        ranks.put(reference, value);
        ranks = ranks.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        this.save();
    }

    public boolean removeRank(String reference) {
        boolean result;
        boolean bl = result = ranks.remove(reference) != null;
        if (result) {
            this.save();
        }
        return result;
    }

    public int getRankValue(String reference) {
        return ranks.getOrDefault(reference, 0);
    }

    public Map<String, Integer> getRanks() {
        return new LinkedHashMap<String, Integer>(ranks);
    }

    public int getRankUpValue(int currentRank) {
        return this.getRanks().values().stream().mapToInt(x -> {
            if (x > currentRank) {
                return x;
            }
            return 1000;
        }).min().orElse(currentRank);
    }

    public int getRankDownValue(int currentRank) {
        return this.getRanks().values().stream().mapToInt(x -> {
            if (x < currentRank) {
                return x;
            }
            return 0;
        }).max().orElse(currentRank);
    }

    public String getRank(int rank) {
        for (Map.Entry<String, Integer> en : ranks.entrySet()) {
            if (rank != en.getValue()) continue;
            return en.getKey();
        }
        return "";
    }
}

