/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.managers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.hooks.Hook;

public class HooksManager {
    private final BentoBox plugin;
    private final Map<String, Hook> hooks;

    public HooksManager(BentoBox plugin) {
        this.plugin = plugin;
        this.hooks = new HashMap<String, Hook>();
    }

    public void registerHook(@NonNull Hook hook) {
        if (hook.isPluginAvailable()) {
            this.plugin.log("Hooking with " + hook.getPluginName() + "...");
            if (hook.hook()) {
                this.hooks.put(hook.getPluginName(), hook);
            } else {
                this.plugin.logError("Could not hook with " + hook.getPluginName() + (String)(hook.getFailureCause() != null ? " because: " + hook.getFailureCause() : "") + ". Skipping...");
            }
        }
    }

    public List<Hook> getHooks() {
        return List.copyOf(this.hooks.values());
    }

    public Optional<Hook> getHook(String pluginName) {
        return Optional.ofNullable(this.hooks.get(pluginName));
    }
}

