/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners.flags.worldsettings;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import world.bentobox.bentobox.api.flags.FlagListener;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.lists.Flags;

public class CreeperListener
extends FlagListener {
    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onExplosion(EntityExplodeEvent e) {
        LivingEntity livingEntity;
        if (!e.getEntityType().equals((Object)EntityType.CREEPER) || !this.getIWM().inWorld(e.getLocation())) {
            return;
        }
        if (!Flags.CREEPER_DAMAGE.isSetForWorld(e.getLocation().getWorld())) {
            e.blockList().clear();
            e.setCancelled(false);
        }
        Creeper creeper = (Creeper)e.getEntity();
        if (!Flags.CREEPER_GRIEFING.isSetForWorld(e.getLocation().getWorld()) && (livingEntity = creeper.getTarget()) instanceof Player) {
            Player target = (Player)livingEntity;
            if (!this.getIslands().locationIsOnIsland(target, e.getLocation())) {
                User user = User.getInstance(target);
                user.notify("protection.protected", "[description]", user.getTranslation(Flags.CREEPER_GRIEFING.getHintReference(), new String[0]));
                e.setCancelled(true);
                e.blockList().clear();
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent e) {
        Material mainHand;
        Player player = e.getPlayer();
        Location location = e.getRightClicked().getLocation();
        if (this.getPlugin().getIWM().inWorld(location) && !Flags.CREEPER_GRIEFING.isSetForWorld(location.getWorld()) && e.getRightClicked() instanceof Creeper && !this.getIslandsManager().locationIsOnIsland(player, location) && (Material.FIRE_CHARGE.equals((Object)(mainHand = player.getInventory().getItemInMainHand().getType())) || Material.FLINT_AND_STEEL.equals((Object)mainHand))) {
            User user = User.getInstance(player);
            user.notify("protection.protected", "[description]", user.getTranslation(Flags.CREEPER_GRIEFING.getHintReference(), new String[0]));
            e.setCancelled(true);
        }
    }
}

