/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners.flags.protection;

import java.util.Set;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import world.bentobox.bentobox.api.flags.FlagListener;
import world.bentobox.bentobox.lists.Flags;

public class PlaceBlocksListener
extends FlagListener {
    public static final Set<Material> SEEDS = Set.of(Material.MELON_SEEDS, Material.WHEAT_SEEDS, Material.SWEET_BERRIES);

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent e) {
        Material m = e.getBlock().getType();
        Material against = e.getBlockAgainst().getType();
        if (m.equals((Object)Material.FIRE) || e.getItemInHand() == null || e.getItemInHand().getType().equals((Object)Material.WRITABLE_BOOK) || e.getItemInHand().getType().equals((Object)Material.WRITTEN_BOOK)) {
            return;
        }
        if (e.getItemInHand().getType() == Material.GLOW_BERRIES && e.getBlock().getRelative(BlockFace.UP).equals((Object)e.getBlockAgainst())) {
            this.checkIsland((Event)e, e.getPlayer(), e.getBlock().getLocation(), Flags.CROP_PLANTING);
            return;
        }
        if (against.equals((Object)Material.FARMLAND) && (SEEDS.contains(e.getItemInHand().getType()) || Tag.ITEMS_VILLAGER_PLANTABLE_SEEDS.isTagged((Keyed)e.getItemInHand().getType()))) {
            this.checkIsland((Event)e, e.getPlayer(), e.getBlock().getLocation(), Flags.CROP_PLANTING);
        } else {
            this.checkIsland((Event)e, e.getPlayer(), e.getBlock().getLocation(), Flags.PLACE_BLOCKS);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onHangingPlace(HangingPlaceEvent e) {
        this.checkIsland((Event)e, e.getPlayer(), e.getBlock().getLocation(), Flags.PLACE_BLOCKS);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerHitItemFrame(PlayerInteractEntityEvent e) {
        if (e.getRightClicked().getType().equals((Object)EntityType.ITEM_FRAME) || e.getRightClicked().getType().equals((Object)EntityType.GLOW_ITEM_FRAME)) {
            if (!this.checkIsland((Event)e, e.getPlayer(), e.getRightClicked().getLocation(), Flags.PLACE_BLOCKS)) {
                return;
            }
            this.checkIsland((Event)e, e.getPlayer(), e.getRightClicked().getLocation(), Flags.ITEM_FRAME);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent e) {
        if (!e.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) || e.getClickedBlock() == null) {
            return;
        }
        switch (e.getClickedBlock().getType()) {
            case FIREWORK_ROCKET: {
                this.checkIsland((Event)e, e.getPlayer(), e.getClickedBlock().getLocation(), Flags.PLACE_BLOCKS);
                break;
            }
            case RAIL: 
            case POWERED_RAIL: 
            case DETECTOR_RAIL: 
            case ACTIVATOR_RAIL: {
                if (e.getMaterial() != Material.MINECART && e.getMaterial() != Material.CHEST_MINECART && e.getMaterial() != Material.HOPPER_MINECART && e.getMaterial() != Material.TNT_MINECART && e.getMaterial() != Material.FURNACE_MINECART) break;
                this.checkIsland((Event)e, e.getPlayer(), e.getClickedBlock().getLocation(), Flags.MINECART);
                break;
            }
            default: {
                if (e.getMaterial() == Material.FIREWORK_ROCKET || e.getMaterial() == Material.ARMOR_STAND || e.getMaterial() == Material.END_CRYSTAL || e.getMaterial() == Material.ITEM_FRAME || e.getMaterial() == Material.GLOW_ITEM_FRAME || e.getMaterial() == Material.CHEST || e.getMaterial() == Material.TRAPPED_CHEST) {
                    this.checkIsland((Event)e, e.getPlayer(), e.getPlayer().getLocation(), Flags.PLACE_BLOCKS);
                    break;
                }
                if (!Tag.ITEMS_BOATS.isTagged((Keyed)e.getMaterial())) break;
                this.checkIsland((Event)e, e.getPlayer(), e.getPlayer().getLocation(), Flags.BOAT);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockForm(EntityBlockFormEvent e) {
        Entity entity;
        if (e.getNewState().getType().equals((Object)Material.FROSTED_ICE) && (entity = e.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            this.checkIsland((Event)e, player, e.getBlock().getLocation(), Flags.FROST_WALKER);
        }
    }
}

