/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners.flags.protection;

import com.google.common.base.Enums;
import java.lang.reflect.Method;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.data.type.CaveVinesPlant;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.projectiles.ProjectileSource;
import world.bentobox.bentobox.api.flags.FlagListener;
import world.bentobox.bentobox.lists.Flags;

public class BreakBlocksListener
extends FlagListener {
    private static final Method BERRIES_CHECK;

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent e) {
        Player p = e.getPlayer();
        Location l = e.getBlock().getLocation();
        Material m = e.getBlock().getType();
        if (m.equals((Object)Material.MELON) || m.equals((Object)Material.PUMPKIN)) {
            this.checkIsland((Event)e, p, l, Flags.HARVEST);
        } else if (Tag.CROPS.isTagged((Keyed)m) && !m.equals((Object)Material.MELON_STEM) && !m.equals((Object)Material.PUMPKIN_STEM) && !m.equals((Object)Material.ATTACHED_MELON_STEM) && !m.equals((Object)Material.ATTACHED_PUMPKIN_STEM) || m == Material.COCOA || m == Material.SWEET_BERRY_BUSH || m == Material.BAMBOO || m == Material.NETHER_WART || m == Material.CACTUS) {
            this.checkIsland((Event)e, p, l, Flags.HARVEST);
        } else {
            this.checkIsland((Event)e, p, l, Flags.BREAK_BLOCKS);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onBreakHanging(HangingBreakByEntityEvent e) {
        Projectile p;
        Entity entity;
        Entity entity2 = e.getRemover();
        if (entity2 instanceof Player) {
            Player r = (Player)entity2;
            this.checkIsland((Event)e, r, e.getEntity().getLocation(), Flags.BREAK_BLOCKS);
        }
        if ((entity = e.getRemover()) instanceof Projectile && (entity = (p = (Projectile)entity).getShooter()) instanceof Player) {
            Player s = (Player)entity;
            this.checkIsland((Event)e, s, e.getEntity().getLocation(), Flags.BREAK_BLOCKS);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent e) {
        if (e.getClickedBlock() == null) {
            return;
        }
        Player p = e.getPlayer();
        Location l = e.getClickedBlock().getLocation();
        Material m = e.getClickedBlock().getType();
        if (e.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Material clickedType = e.getClickedBlock().getType();
            switch (clickedType) {
                case CAVE_VINES: 
                case CAVE_VINES_PLANT: {
                    try {
                        boolean hasBerries = (Boolean)BERRIES_CHECK.invoke((Object)((CaveVinesPlant)e.getClickedBlock().getBlockData()), new Object[0]);
                        if (!hasBerries) break;
                        this.checkIsland((Event)e, p, l, Flags.HARVEST);
                    }
                    catch (ReflectiveOperationException ex) {
                        this.getPlugin().logStacktrace(ex);
                    }
                    break;
                }
                case SWEET_BERRY_BUSH: {
                    this.checkIsland((Event)e, p, l, Flags.HARVEST);
                    break;
                }
                case ROOTED_DIRT: {
                    this.checkIsland((Event)e, p, l, Flags.BREAK_BLOCKS);
                    break;
                }
            }
            return;
        }
        if (e.getAction() != Action.LEFT_CLICK_BLOCK || e.getClickedBlock() == null) {
            return;
        }
        if (Enums.getIfPresent(Material.class, (String)"TRIAL_SPAWNER").isPresent() && m.equals((Object)Material.TRIAL_SPAWNER)) {
            this.checkIsland((Event)e, p, l, Flags.BREAK_SPAWNERS);
            return;
        }
        switch (m) {
            case CAKE: {
                this.checkIsland((Event)e, p, l, Flags.BREAK_BLOCKS);
                break;
            }
            case SPAWNER: {
                this.checkIsland((Event)e, p, l, Flags.BREAK_SPAWNERS);
                break;
            }
            case DRAGON_EGG: {
                this.checkIsland((Event)e, p, l, Flags.DRAGON_EGG);
                break;
            }
            case HOPPER: {
                this.checkIsland((Event)e, p, l, Flags.BREAK_HOPPERS);
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onVehicleDamageEvent(VehicleDamageEvent e) {
        Entity entity;
        Location l = e.getVehicle().getLocation();
        if (this.getIWM().inWorld(l) && (entity = e.getAttacker()) instanceof Player) {
            Player p = (Player)entity;
            String vehicleType = e.getVehicle().getType().name();
            if (vehicleType.contains("BOAT")) {
                this.checkIsland((Event)e, p, l, Flags.BOAT);
            } else if (vehicleType.contains("MINECART")) {
                this.checkIsland((Event)e, p, l, Flags.MINECART);
            } else {
                this.checkIsland((Event)e, p, l, Flags.BREAK_BLOCKS);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageByEntityEvent e) {
        if (!(e.getEntity() instanceof ItemFrame || e.getEntity() instanceof ArmorStand || e.getEntity() instanceof EnderCrystal)) {
            return;
        }
        Entity entity = e.getDamager();
        if (entity instanceof Player) {
            Player p = (Player)entity;
            this.notAllowed(e, p, e.getEntity().getLocation());
        } else {
            Player player;
            Projectile p;
            entity = e.getDamager();
            if (entity instanceof Projectile && (entity = (p = (Projectile)entity).getShooter()) instanceof Player && this.notAllowed(e, player = (Player)entity, e.getEntity().getLocation())) {
                e.getEntity().setFireTicks(0);
                p.setFireTicks(0);
            }
        }
    }

    private boolean notAllowed(EntityDamageByEntityEvent e, Player player, Location location) {
        if (!this.checkIsland((Event)e, player, location, Flags.BREAK_BLOCKS)) {
            return true;
        }
        if (e.getEntity() instanceof ItemFrame) {
            return !this.checkIsland((Event)e, player, location, Flags.ITEM_FRAME);
        }
        if (e.getEntity() instanceof ArmorStand) {
            return !this.checkIsland((Event)e, player, location, Flags.ARMOR_STAND);
        }
        return false;
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onProjectileHitBreakBlock(ProjectileHitEvent e) {
        Player s;
        if (e.getHitBlock() == null) {
            return;
        }
        if (!e.getHitBlock().getType().equals((Object)Material.CHORUS_FLOWER) && !e.getHitBlock().getType().equals((Object)Material.DECORATED_POT)) {
            return;
        }
        ProjectileSource projectileSource = e.getEntity().getShooter();
        if (projectileSource instanceof Player && !this.checkIsland((Event)e, s = (Player)projectileSource, e.getHitBlock().getLocation(), Flags.BREAK_BLOCKS)) {
            e.setCancelled(true);
        }
    }

    static {
        Method m = null;
        try {
            m = CaveVinesPlant.class.getMethod("hasBerries", new Class[0]);
        }
        catch (NoSuchMethodException ignored) {
            try {
                m = CaveVinesPlant.class.getMethod("isBerries", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        BERRIES_CHECK = m;
    }
}

