/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.lists.Flags;

public class BlockEndDragon
implements Listener {
    private final BentoBox plugin;

    public BlockEndDragon(@NonNull BentoBox plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerChangeWorld(PlayerChangedWorldEvent event) {
        this.testLocation(event.getPlayer().getLocation());
    }

    private void testLocation(Location location) {
        World w = location.getWorld();
        if (w == null || !this.plugin.getIWM().isIslandEnd(w) || !Flags.REMOVE_END_EXIT_ISLAND.isSetForWorld(w) || w.getBlockAt(0, w.getMaxHeight() - 1, 0).getType().equals((Object)Material.END_PORTAL)) {
            return;
        }
        w.getBlockAt(0, w.getMaxHeight() - 1, 0).setType(Material.END_PORTAL, false);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerJoinWorld(PlayerJoinEvent event) {
        this.testLocation(event.getPlayer().getLocation());
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEndBlockPlace(BlockPlaceEvent e) {
        e.setCancelled(this.testBlock(e.getBlock()));
    }

    private boolean testBlock(Block block) {
        return block.getX() == 0 && block.getZ() == 0 && block.getY() == block.getWorld().getMaxHeight() - 1 && block.getWorld().getEnvironment().equals((Object)World.Environment.THE_END) && Flags.REMOVE_END_EXIT_ISLAND.isSetForWorld(block.getWorld()) && this.plugin.getIWM().inWorld(block.getWorld()) && this.plugin.getIWM().isEndGenerate(block.getWorld()) && this.plugin.getIWM().isEndIslands(block.getWorld());
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEndBlockBreak(BlockBreakEvent e) {
        e.setCancelled(this.testBlock(e.getBlock()));
    }
}

