/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.hooks;

import com.bergerkiller.bukkit.mw.WorldConfigStore;
import org.bukkit.Material;
import org.bukkit.World;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.hooks.Hook;
import world.bentobox.bentobox.hooks.WorldManagementHook;

public class MyWorldsHook
extends Hook
implements WorldManagementHook {
    public MyWorldsHook() {
        super("My_Worlds", Material.FILLED_MAP);
    }

    @Override
    public void registerWorld(World world, boolean islandWorld) {
        if (islandWorld) {
            boolean hasGenerator = BentoBox.getInstance().getIWM().getAddon(world).map(gm -> gm.getDefaultWorldGenerator(world.getName(), "") != null).orElse(false);
            this.setUseBentoboxGenerator(world, hasGenerator);
        } else {
            this.setUseBentoboxGenerator(world, false);
        }
    }

    private void setUseBentoboxGenerator(World world, boolean hasGenerator) {
        String name = hasGenerator ? BentoBox.getInstance().getName() : null;
        try {
            WorldConfigStore.get((World)world).setChunkGeneratorName(name);
        }
        catch (Exception t) {
            BentoBox.getInstance().logError("Failed to register world " + world.getName() + " with MyWorlds " + t.getMessage());
        }
    }

    @Override
    public boolean hook() {
        return true;
    }

    @Override
    public String getFailureCause() {
        return null;
    }
}

