/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.database.transition;

import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.database.AbstractDatabaseHandler;

public class TransitionDatabaseHandler<T>
extends AbstractDatabaseHandler<T> {
    private final AbstractDatabaseHandler<T> fromHandler;
    private final AbstractDatabaseHandler<T> toHandler;

    TransitionDatabaseHandler(Class<T> type, AbstractDatabaseHandler<T> fromHandler, AbstractDatabaseHandler<T> toHandler) {
        this.fromHandler = fromHandler;
        this.toHandler = toHandler;
    }

    @Override
    public List<T> loadObjects() throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, IntrospectionException, NoSuchMethodException {
        List<T> listFrom = this.fromHandler.loadObjects();
        List<T> listTo = this.toHandler.loadObjects();
        for (T object : listFrom) {
            this.toHandler.saveObject(object).thenAccept(b -> {
                if (b.booleanValue()) {
                    try {
                        this.fromHandler.deleteObject(object);
                    }
                    catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
                        this.plugin.logStacktrace(e);
                    }
                }
            });
        }
        listTo.addAll(listFrom);
        return listTo;
    }

    @Override
    public T loadObject(@NonNull String uniqueId) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, IntrospectionException, NoSuchMethodException {
        @Nullable T object = this.toHandler.loadObject(uniqueId);
        if (object == null && (object = this.fromHandler.loadObject(uniqueId)) != null) {
            this.toHandler.saveObject(object);
            this.fromHandler.deleteObject(object);
        }
        return object;
    }

    @Override
    public boolean objectExists(String uniqueId) {
        return this.toHandler.objectExists(uniqueId) || this.fromHandler.objectExists(uniqueId);
    }

    @Override
    public CompletableFuture<Boolean> saveObject(T instance) throws IllegalAccessException, InvocationTargetException, IntrospectionException {
        return this.toHandler.saveObject(instance);
    }

    @Override
    public void deleteID(String uniqueId) {
        this.toHandler.deleteID(uniqueId);
        this.fromHandler.deleteID(uniqueId);
    }

    @Override
    public void deleteObject(T instance) throws IllegalAccessException, InvocationTargetException, IntrospectionException {
        this.toHandler.deleteObject(instance);
        this.fromHandler.deleteObject(instance);
    }

    @Override
    public void close() {
    }
}

