/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.database.sql.mariadb;

import com.zaxxer.hikari.HikariConfig;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.database.DatabaseConnectionSettingsImpl;
import world.bentobox.bentobox.database.sql.SQLDatabaseConnector;

public class MariaDBDatabaseConnector
extends SQLDatabaseConnector {
    MariaDBDatabaseConnector(@NonNull DatabaseConnectionSettingsImpl dbSettings) {
        super(dbSettings, String.format("jdbc:mariadb://%s:%s/%s", dbSettings.getHost(), dbSettings.getPort(), dbSettings.getDatabaseName()));
    }

    @Override
    public HikariConfig createConfig() {
        HikariConfig config = new HikariConfig();
        config.setPoolName("BentoBox MariaDB Pool");
        config.setDriverClassName("org.mariadb.jdbc.Driver");
        config.setJdbcUrl(this.connectionUrl);
        config.addDataSourceProperty("user", (Object)this.dbSettings.getUsername());
        config.addDataSourceProperty("password", (Object)this.dbSettings.getPassword());
        config.addDataSourceProperty("useSsl", (Object)this.dbSettings.isUseSSL());
        config.addDataSourceProperty("allowMultiQueries", (Object)"true");
        this.dbSettings.getExtraProperties().forEach((arg_0, arg_1) -> ((HikariConfig)config).addDataSourceProperty(arg_0, arg_1));
        config.setMaximumPoolSize(this.dbSettings.getMaxConnections());
        return config;
    }
}

