/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.database.json.adapters;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;

public final class TagTypeAdapter<E extends Keyed>
extends TypeAdapter<Tag<E>> {
    private final TypeAdapter<String> stringAdapter;
    private final String registry;
    private final Class<E> elementType;

    public TagTypeAdapter(Gson gson, String registry, Class<E> elementType) {
        this.stringAdapter = gson.getAdapter(String.class);
        this.registry = registry;
        this.elementType = elementType;
    }

    public void write(JsonWriter out, Tag<E> value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        this.stringAdapter.write(out, (Object)value.getKey().toString());
    }

    public Tag<E> read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        String key = (String)this.stringAdapter.read(in);
        NamespacedKey namespacedKey = NamespacedKey.fromString((String)key);
        if (namespacedKey == null) {
            throw new JsonParseException("Invalid tag key format: " + key);
        }
        Tag tag = Bukkit.getTag((String)this.registry, (NamespacedKey)namespacedKey, this.elementType);
        if (tag == null) {
            throw new JsonParseException("Unknown tag: " + key);
        }
        return tag;
    }
}

