/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.blueprints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Banner;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Sign;
import org.bukkit.block.TrialSpawner;
import org.bukkit.block.data.Attachable;
import org.bukkit.block.sign.Side;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.blueprints.Blueprint;
import world.bentobox.bentobox.blueprints.dataobjects.BlueprintBlock;
import world.bentobox.bentobox.blueprints.dataobjects.BlueprintCreatureSpawner;
import world.bentobox.bentobox.blueprints.dataobjects.BlueprintEntity;
import world.bentobox.bentobox.blueprints.dataobjects.BlueprintTrialSpawner;
import world.bentobox.bentobox.hooks.FancyNpcsHook;
import world.bentobox.bentobox.hooks.ItemsAdderHook;
import world.bentobox.bentobox.hooks.MythicMobsHook;
import world.bentobox.bentobox.hooks.ZNPCsPlusHook;

public class BlueprintClipboard {
    private NamespacedKey key;
    private @Nullable Blueprint blueprint;
    private @Nullable Location pos1;
    private @Nullable Location pos2;
    private @Nullable Vector origin;
    private BukkitTask copyTask;
    private int count;
    private boolean copying;
    private int index;
    private int lastPercentage;
    private final Map<Vector, List<BlueprintEntity>> bpEntities = new LinkedHashMap<Vector, List<BlueprintEntity>>();
    private final Map<Vector, BlueprintBlock> bpAttachable = new LinkedHashMap<Vector, BlueprintBlock>();
    private final Map<Vector, BlueprintBlock> bpBlocks = new LinkedHashMap<Vector, BlueprintBlock>();
    private final BentoBox plugin = BentoBox.getInstance();
    private Optional<MythicMobsHook> mmh;
    private Optional<FancyNpcsHook> npc = this.plugin.getHooks().getHook("FancyNpcs").filter(FancyNpcsHook.class::isInstance).map(FancyNpcsHook.class::cast);
    private Optional<ZNPCsPlusHook> znpc;

    public BlueprintClipboard(@NonNull Blueprint blueprint) {
        this();
        this.blueprint = blueprint;
        this.key = new NamespacedKey((Plugin)BentoBox.getInstance(), "associatedDisplayEntity");
    }

    public BlueprintClipboard() {
        this.mmh = this.plugin.getHooks().getHook("MythicMobs").filter(MythicMobsHook.class::isInstance).map(MythicMobsHook.class::cast);
        this.znpc = this.plugin.getHooks().getHook("ZNPCsPlus").filter(ZNPCsPlusHook.class::isInstance).map(ZNPCsPlusHook.class::cast);
    }

    public boolean copy(User user, boolean copyAir, boolean copyBiome, boolean noWater) {
        if (this.copying) {
            user.sendMessage("commands.admin.blueprint.mid-copy", new String[0]);
            return false;
        }
        if (this.pos1 == null || this.pos2 == null) {
            user.sendMessage("commands.admin.blueprint.need-pos1-pos2", new String[0]);
            return false;
        }
        if (this.origin == null) {
            this.setOrigin(user.getLocation().toVector());
        }
        user.sendMessage("commands.admin.blueprint.copying", new String[0]);
        World world = this.pos1.getWorld();
        if (world == null) {
            return false;
        }
        this.blueprint = new Blueprint();
        this.bpEntities.clear();
        this.bpAttachable.clear();
        this.bpBlocks.clear();
        this.count = 0;
        this.index = 0;
        this.lastPercentage = 0;
        BoundingBox toCopy = BoundingBox.of((Location)this.pos1, (Location)this.pos2);
        this.blueprint.setxSize((int)toCopy.getWidthX());
        this.blueprint.setySize((int)toCopy.getHeight());
        this.blueprint.setzSize((int)toCopy.getWidthZ());
        int speed = this.plugin.getSettings().getPasteSpeed();
        List<Vector> vectorsToCopy = this.getVectors(toCopy);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.copyAsync(world, user, vectorsToCopy, speed, copyAir, copyBiome, noWater));
        return true;
    }

    private void copyAsync(World world, User user, List<Vector> vectorsToCopy, int speed, boolean copyAir, boolean copyBiome, boolean noWater) {
        this.copying = false;
        if (this.npc.isPresent()) {
            this.bpEntities.putAll(this.npc.get().getNpcsInArea(world, vectorsToCopy, this.origin));
        }
        if (this.znpc.isPresent()) {
            this.bpEntities.putAll(this.znpc.get().getNpcsInArea(world, vectorsToCopy, this.origin));
        }
        this.copyTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (this.copying) {
                return;
            }
            this.copying = true;
            vectorsToCopy.stream().skip(this.index).limit(speed).forEach(v -> {
                List<Entity> ents = world.getEntities().stream().filter(Objects::nonNull).filter(e -> !(e instanceof Player)).filter(e -> !e.getPersistentDataContainer().has(this.key, PersistentDataType.STRING)).filter(e -> new Vector(e.getLocation().getBlockX(), e.getLocation().getBlockY(), e.getLocation().getBlockZ()).equals(v)).toList();
                if (this.copyBlock(v.toLocation(world), copyAir, copyBiome, ents, noWater)) {
                    ++this.count;
                }
            });
            this.index += speed;
            int percent = (int)((double)(this.index * 100) / (double)vectorsToCopy.size());
            if (percent != this.lastPercentage && percent % 10 == 0) {
                user.sendMessage("commands.admin.blueprint.copied-percent", "[number]", String.valueOf(percent));
                this.lastPercentage = percent;
            }
            if (this.index > vectorsToCopy.size()) {
                this.copyTask.cancel();
                assert (this.blueprint != null);
                this.blueprint.setAttached(this.bpAttachable);
                this.blueprint.setBlocks(this.bpBlocks);
                this.blueprint.setEntities(this.bpEntities);
                user.sendMessage("general.success", new String[0]);
                user.sendMessage("commands.admin.blueprint.copied-blocks", "[number]", String.valueOf(this.count));
            }
            this.copying = false;
        }, 0L, 1L);
    }

    protected List<Vector> getVectors(BoundingBox b) {
        ArrayList<Vector> r = new ArrayList<Vector>();
        int y = (int)Math.floor(b.getMinY());
        while ((double)y <= b.getMaxY()) {
            int x = (int)Math.floor(b.getMinX());
            while ((double)x <= b.getMaxX()) {
                int z = (int)Math.floor(b.getMinZ());
                while ((double)z <= b.getMaxZ()) {
                    r.add(new Vector(x, y, z));
                    ++z;
                }
                ++x;
            }
            ++y;
        }
        return r;
    }

    private boolean copyBlock(Location l, boolean copyAir, boolean copyBiome, List<Entity> ents, boolean noWater) {
        Block block = l.getBlock();
        if (!copyAir && block.getType().equals((Object)Material.AIR) && ents.isEmpty()) {
            return false;
        }
        if (noWater && block.getType() == Material.WATER && ents.isEmpty()) {
            return false;
        }
        Vector origin2 = this.origin == null ? new Vector(0, 0, 0) : this.origin;
        int x = l.getBlockX() - origin2.getBlockX();
        int y = l.getBlockY() - origin2.getBlockY();
        int z = l.getBlockZ() - origin2.getBlockZ();
        Vector pos = new Vector(x, y, z);
        List<BlueprintEntity> bpEnts = this.setEntities(ents);
        if (!bpEnts.isEmpty()) {
            this.bpEntities.put(pos, bpEnts);
        }
        if (!copyAir && block.getType().equals((Object)Material.AIR) && !ents.isEmpty()) {
            return true;
        }
        if (noWater && block.getType().equals((Object)Material.WATER) && !ents.isEmpty()) {
            return true;
        }
        BlueprintBlock b = this.bluePrintBlock(pos, block, copyBiome);
        if (b != null) {
            this.bpBlocks.put(pos, b);
        }
        return true;
    }

    private BlueprintBlock bluePrintBlock(Vector pos, Block block, boolean copyBiome) {
        CreatureSpawner spawner;
        BlockState blockState = block.getState();
        BlueprintBlock b = new BlueprintBlock(block.getBlockData().getAsString());
        if (copyBiome) {
            b.setBiome(block.getBiome());
        }
        if (blockState instanceof Sign) {
            Sign sign = (Sign)blockState;
            for (Side side : Side.values()) {
                b.setSignLines(side, Arrays.asList(sign.getSide(side).getLines()));
                b.setGlowingText(side, sign.getSide(side).isGlowingText());
            }
        }
        if (blockState.getBlockData() instanceof Attachable) {
            this.bpBlocks.put(pos, new BlueprintBlock("minecraft:air"));
            this.plugin.getHooks().getHook("ItemsAdder").ifPresent(hook -> {
                String iab = ItemsAdderHook.getInCustomRegion(block.getLocation());
                if (iab != null) {
                    b.setItemsAdderBlock(iab);
                }
            });
            this.bpAttachable.put(pos, b);
            return null;
        }
        if (block.getType().equals((Object)Material.BEDROCK)) {
            if (this.blueprint.getBedrock() == null) {
                this.blueprint.setBedrock(pos);
            } else if (pos.getBlockY() > this.blueprint.getBedrock().getBlockY()) {
                this.blueprint.setBedrock(pos);
            }
        }
        if (blockState instanceof InventoryHolder) {
            InventoryHolder ih = (InventoryHolder)blockState;
            b.setInventory(new HashMap<Integer, ItemStack>());
            for (int i = 0; i < ih.getInventory().getSize(); ++i) {
                ItemStack item = ih.getInventory().getItem(i);
                if (item == null) continue;
                b.getInventory().put(i, item);
            }
        }
        if (blockState instanceof CreatureSpawner) {
            spawner = (CreatureSpawner)blockState;
            b.setCreatureSpawner(this.getSpawner(spawner));
        }
        if (blockState instanceof TrialSpawner) {
            spawner = (TrialSpawner)blockState;
            if (spawner.isOminous()) {
                b.setTrialSpawner(new BlueprintTrialSpawner(true, spawner.getOminousConfiguration()));
            } else {
                b.setTrialSpawner(new BlueprintTrialSpawner(false, spawner.getNormalConfiguration()));
            }
        }
        if (blockState instanceof Banner) {
            Banner banner = (Banner)blockState;
            b.setBannerPatterns(banner.getPatterns());
        }
        this.plugin.getHooks().getHook("ItemsAdder").ifPresent(hook -> {
            String iab = ItemsAdderHook.getInCustomRegion(block.getLocation());
            if (iab != null) {
                b.setItemsAdderBlock(iab);
            }
        });
        return b;
    }

    private BlueprintCreatureSpawner getSpawner(CreatureSpawner spawner) {
        BlueprintCreatureSpawner cs = new BlueprintCreatureSpawner();
        cs.setSpawnedType(spawner.getSpawnedType());
        cs.setDelay(spawner.getDelay());
        cs.setMaxNearbyEntities(spawner.getMaxNearbyEntities());
        cs.setMaxSpawnDelay(spawner.getMaxSpawnDelay());
        cs.setMinSpawnDelay(spawner.getMinSpawnDelay());
        cs.setRequiredPlayerRange(spawner.getRequiredPlayerRange());
        cs.setSpawnRange(spawner.getSpawnRange());
        return cs;
    }

    private List<BlueprintEntity> setEntities(List<Entity> ents) {
        ArrayList<BlueprintEntity> bpEnts = new ArrayList<BlueprintEntity>();
        for (Entity entity : ents) {
            BlueprintEntity bpe = new BlueprintEntity(entity);
            this.mmh.filter(mm -> mm.isMythicMob(entity)).map(mm -> mm.getMythicMob(entity)).ifPresent(bpe::setMythicMobsRecord);
            bpEnts.add(bpe);
        }
        return bpEnts;
    }

    public @Nullable Vector getOrigin() {
        return this.origin;
    }

    public @Nullable Location getPos1() {
        return this.pos1;
    }

    public @Nullable Location getPos2() {
        return this.pos2;
    }

    public boolean isFull() {
        return this.blueprint != null;
    }

    public void setOrigin(@Nullable Vector origin) {
        this.origin = origin;
    }

    public void setPos1(@Nullable Location pos1) {
        this.origin = null;
        if (pos1 != null) {
            int maxHeight;
            int minHeight = pos1.getWorld() == null ? 0 : pos1.getWorld().getMinHeight();
            int n = maxHeight = pos1.getWorld() == null ? 255 : pos1.getWorld().getMaxHeight();
            if (pos1.getBlockY() < minHeight) {
                pos1.setY((double)minHeight);
            }
            if (pos1.getBlockY() > maxHeight) {
                pos1.setY((double)maxHeight);
            }
        }
        this.pos1 = pos1;
    }

    public void setPos2(@Nullable Location pos2) {
        this.origin = null;
        if (pos2 != null) {
            int maxHeight;
            int minHeight = pos2.getWorld() == null ? 0 : pos2.getWorld().getMinHeight();
            int n = maxHeight = pos2.getWorld() == null ? 255 : pos2.getWorld().getMaxHeight();
            if (pos2.getBlockY() < minHeight) {
                pos2.setY((double)minHeight);
            }
            if (pos2.getBlockY() > maxHeight) {
                pos2.setY((double)maxHeight);
            }
        }
        this.pos2 = pos2;
    }

    public @Nullable Blueprint getBlueprint() {
        return this.blueprint;
    }

    public BlueprintClipboard setBlueprint(Blueprint blueprint) {
        this.blueprint = blueprint;
        return this;
    }
}

