/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.panels.builders;

import java.security.InvalidParameterException;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.World;
import world.bentobox.bentobox.api.panels.Tab;
import world.bentobox.bentobox.api.panels.TabbedPanel;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;

public class TabbedPanelBuilder {
    private int size;
    private final Map<Integer, Tab> tabs = new TreeMap<Integer, Tab>();
    private int startingSlot;
    private World world;
    private User user;
    private boolean hideIfEmpty;
    private Island island;

    public TabbedPanelBuilder island(Island island) {
        this.island = island;
        return this;
    }

    public TabbedPanelBuilder size(int size) {
        this.size = size;
        return this;
    }

    public TabbedPanelBuilder user(User user) {
        this.user = user;
        return this;
    }

    public TabbedPanelBuilder world(World world) {
        this.world = world;
        return this;
    }

    public TabbedPanelBuilder tab(int slot, Tab tab) {
        if (slot < 0 || slot > 9) {
            throw new InvalidParameterException("Slot must be between 0 and 9");
        }
        this.tabs.put(slot, tab);
        return this;
    }

    public TabbedPanelBuilder startingSlot(int slot) {
        if (slot < 0 || slot > 9) {
            throw new InvalidParameterException("Slot must be between 0 and 9");
        }
        this.startingSlot = slot;
        return this;
    }

    public TabbedPanelBuilder hideIfEmpty() {
        this.hideIfEmpty = true;
        return this;
    }

    public TabbedPanel build() {
        if (!this.tabs.isEmpty() && !this.tabs.containsKey(this.startingSlot)) {
            this.startingSlot = (Integer)((TreeMap)this.tabs).firstKey();
        }
        TabbedPanel tp = new TabbedPanel(this);
        this.tabs.values().forEach(tab -> tab.setParentPanel(tp));
        return tp;
    }

    public Map<Integer, Tab> getTabs() {
        return this.tabs;
    }

    public int getStartingSlot() {
        return this.startingSlot;
    }

    public World getWorld() {
        return this.world;
    }

    public int getSize() {
        return this.size;
    }

    public User getUser() {
        return this.user;
    }

    public boolean isHideIfEmpty() {
        return this.hideIfEmpty;
    }

    public Island getIsland() {
        return this.island;
    }
}

