/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.panels.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.util.Util;

public class PanelItemBuilder {
    private ItemStack icon = new ItemStack(Material.AIR);
    private @Nullable String name = "";
    private List<String> description = new ArrayList<String>();
    private boolean glow = false;
    private PanelItem.ClickHandler clickHandler;
    private String playerHeadName;
    private boolean invisible;
    private int amount = 1;

    public PanelItemBuilder icon(@Nullable Material icon) {
        this.icon = icon == null ? new ItemStack(Material.PAPER) : new ItemStack(icon);
        return this;
    }

    public PanelItemBuilder icon(@Nullable ItemStack icon) {
        this.icon = icon == null ? new ItemStack(Material.PAPER) : icon;
        this.amount = this.icon.getAmount();
        return this;
    }

    public PanelItemBuilder icon(String playerName) {
        this.icon = new ItemStack(Material.PLAYER_HEAD, 1);
        this.playerHeadName = playerName;
        return this;
    }

    public PanelItemBuilder name(@Nullable String name) {
        this.name = name != null ? Util.translateColorCodes(name) : null;
        return this;
    }

    public PanelItemBuilder amount(int amount) {
        this.amount = amount;
        return this;
    }

    public PanelItemBuilder description(List<String> description) {
        description.forEach(this::description);
        return this;
    }

    public PanelItemBuilder description(String ... description) {
        List<String> additions = Arrays.asList(description);
        ArrayList<String> updatableList = new ArrayList<String>();
        updatableList.addAll(this.description);
        updatableList.addAll(additions);
        this.description = updatableList;
        return this;
    }

    public PanelItemBuilder description(String description) {
        if (description != null) {
            Collections.addAll(this.description, description.split("\n"));
        }
        return this;
    }

    public PanelItemBuilder glow(boolean glow) {
        this.glow = glow;
        return this;
    }

    public PanelItemBuilder invisible(boolean invisible) {
        this.invisible = invisible;
        return this;
    }

    public PanelItemBuilder clickHandler(PanelItem.ClickHandler clickHandler) {
        this.clickHandler = clickHandler;
        return this;
    }

    public PanelItem build() {
        return new PanelItem(this);
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public List<String> getDescription() {
        return this.description;
    }

    public boolean isGlow() {
        return this.glow;
    }

    public PanelItem.ClickHandler getClickHandler() {
        return this.clickHandler;
    }

    public boolean isPlayerHead() {
        return this.playerHeadName != null && !this.playerHeadName.isEmpty();
    }

    public String getPlayerHeadName() {
        return this.playerHeadName;
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public int getAmount() {
        return this.amount;
    }
}

