/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.panels.builders;

import java.util.SortedMap;
import java.util.TreeMap;
import org.bukkit.World;
import world.bentobox.bentobox.api.panels.Panel;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.api.panels.PanelListener;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.util.Util;

public class PanelBuilder {
    private String name;
    private final SortedMap<Integer, PanelItem> items = new TreeMap<Integer, PanelItem>();
    private int size;
    private User user;
    private PanelListener listener;
    private Panel.Type type = Panel.Type.INVENTORY;
    private World world;

    public PanelBuilder name(String name) {
        this.name = Util.translateColorCodes(name);
        return this;
    }

    public PanelBuilder item(PanelItem item) {
        if (item == null) {
            return this;
        }
        return this.item(this.nextSlot(), item);
    }

    public PanelBuilder item(int slot, PanelItem item) {
        if (item == null) {
            return this;
        }
        this.items.put(slot, item);
        return this;
    }

    public PanelBuilder size(int size) {
        this.size = size;
        return this;
    }

    public PanelBuilder user(User user) {
        this.user = user;
        return this;
    }

    public PanelBuilder listener(PanelListener listener) {
        this.listener = listener;
        return this;
    }

    public PanelBuilder type(Panel.Type type) {
        this.type = type;
        return this;
    }

    public int nextSlot() {
        return this.items.isEmpty() ? 0 : this.items.lastKey() + 1;
    }

    public boolean slotOccupied(int slot) {
        return this.items.containsKey(slot);
    }

    public PanelBuilder world(World world) {
        this.world = world;
        return this;
    }

    public Panel build() {
        return new Panel(this);
    }

    public String getName() {
        return this.name;
    }

    public SortedMap<Integer, PanelItem> getItems() {
        return this.items;
    }

    public int getSize() {
        return this.size;
    }

    public User getUser() {
        return this.user;
    }

    public PanelListener getListener() {
        return this.listener;
    }

    public Panel.Type getPanelType() {
        return this.type;
    }

    public World getWorld() {
        return this.world;
    }
}

