/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.hooks;

import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class Hook {
    private final @NonNull String pluginName;
    private final @NonNull Material icon;

    protected Hook(@NonNull String pluginName, @NonNull Material icon) {
        if (pluginName.isEmpty()) {
            throw new IllegalArgumentException("Plugin name cannot be empty.");
        }
        this.pluginName = pluginName;
        this.icon = icon;
    }

    public @NonNull String getPluginName() {
        return this.pluginName;
    }

    public @NonNull Material getIcon() {
        return this.icon;
    }

    public @Nullable Plugin getPlugin() {
        return Bukkit.getPluginManager().getPlugin(this.pluginName);
    }

    public boolean isPluginAvailable() {
        return this.getPlugin() != null && this.getPlugin().isEnabled();
    }

    public abstract boolean hook();

    public String getFailureCause() {
        return "";
    }
}

