/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.flags.clicklisteners;

import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.events.flags.FlagWorldSettingChangeEvent;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.api.panels.Panel;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.util.Util;

public class WorldToggleClick
implements PanelItem.ClickHandler {
    private final BentoBox plugin = BentoBox.getInstance();
    private final String id;

    public WorldToggleClick(String id) {
        this.id = id;
    }

    @Override
    public boolean onClick(Panel panel, User user, ClickType click, int slot) {
        World world = panel.getWorld().orElseThrow();
        String reqPerm = this.plugin.getIWM().getPermissionPrefix(world) + "admin.world.settings." + this.id;
        if (!user.hasPermission(reqPerm)) {
            user.sendMessage("general.errors.no-permission", "[permission]", reqPerm);
            user.getPlayer().playSound(user.getLocation(), Sound.BLOCK_METAL_HIT, 1.0f, 1.0f);
            return true;
        }
        this.plugin.getFlagsManager().getFlag(this.id).ifPresent(flag -> {
            if (click.equals((Object)ClickType.SHIFT_LEFT) && user.isOp()) {
                if (!this.plugin.getIWM().getHiddenFlags(world).contains(flag.getID())) {
                    this.plugin.getIWM().getHiddenFlags(world).add(flag.getID());
                    user.getPlayer().playSound(user.getLocation(), Sound.BLOCK_GLASS_BREAK, 1.0f, 1.0f);
                } else {
                    this.plugin.getIWM().getHiddenFlags(world).remove(flag.getID());
                    user.getPlayer().playSound(user.getLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 1.0f, 1.0f);
                }
                this.plugin.getIWM().getAddon(world).ifPresent(GameModeAddon::saveWorldSettings);
            } else {
                flag.setSetting(world, !flag.isSetForWorld(world));
                user.getPlayer().playSound(user.getLocation(), Sound.BLOCK_STONE_BUTTON_CLICK_ON, 1.0f, 1.0f);
                Bukkit.getPluginManager().callEvent((Event)new FlagWorldSettingChangeEvent(world, user.getUniqueId(), (Flag)flag, flag.isSetForWorld(world)));
                if (flag.hasSubflags()) {
                    flag.getSubflags().forEach(subflag -> Bukkit.getPluginManager().callEvent((Event)new FlagWorldSettingChangeEvent(world, user.getUniqueId(), (Flag)subflag, subflag.isSetForWorld(world))));
                }
            }
            this.plugin.getIWM().getAddon(Util.getWorld(world)).ifPresent(GameModeAddon::saveWorldSettings);
        });
        return true;
    }
}

