/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.events.command;

import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.api.events.BentoBoxEvent;

public class CommandEvent
extends BentoBoxEvent
implements Cancellable {
    private boolean cancelled;
    private final CommandSender sender;
    private final Command command;
    private final String label;
    private final String[] args;
    private static final HandlerList handlers = new HandlerList();

    @Override
    public @NonNull HandlerList getHandlers() {
        return CommandEvent.getHandlerList();
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    private CommandEvent(CommandSender sender, Command command, String label, String[] args) {
        this.sender = sender;
        this.command = command;
        this.label = label;
        this.args = args;
    }

    public static CommandEventBuilder builder() {
        return new CommandEventBuilder();
    }

    public CommandSender getSender() {
        return this.sender;
    }

    public Command getCommand() {
        return this.command;
    }

    public String getLabel() {
        return this.label;
    }

    public String[] getArgs() {
        return this.args;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean arg0) {
        this.cancelled = arg0;
    }

    public static class CommandEventBuilder {
        private CommandSender sender;
        private Command command;
        private String label;
        private String[] args;

        public CommandEventBuilder setSender(CommandSender sender) {
            this.sender = sender;
            return this;
        }

        public CommandEventBuilder setCommand(Command command) {
            this.command = command;
            return this;
        }

        public CommandEventBuilder setLabel(String label) {
            this.label = label;
            return this;
        }

        public CommandEventBuilder setArgs(String[] args) {
            this.args = args;
            return this;
        }

        public CommandEvent build() {
            CommandEvent event = new CommandEvent(this.sender, this.command, this.label, this.args);
            Bukkit.getPluginManager().callEvent((Event)event);
            return event;
        }
    }
}

