/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.island.team;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.island.team.IslandTeamCommand;
import world.bentobox.bentobox.api.commands.island.team.IslandTeamInviteGUI;
import world.bentobox.bentobox.api.events.IslandBaseEvent;
import world.bentobox.bentobox.api.events.team.TeamEvent;
import world.bentobox.bentobox.api.panels.reader.PanelTemplateRecord;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.database.objects.TeamInvite;
import world.bentobox.bentobox.managers.IslandsManager;
import world.bentobox.bentobox.managers.PlayersManager;
import world.bentobox.bentobox.managers.RanksManager;
import world.bentobox.bentobox.util.Util;

public class IslandTeamInviteCommand
extends CompositeCommand {
    private final IslandTeamCommand itc;
    private @Nullable User invitedPlayer;
    private @Nullable PanelTemplateRecord.TemplateItem border;
    private @Nullable PanelTemplateRecord.TemplateItem background;

    public IslandTeamInviteCommand(IslandTeamCommand parent) {
        super(parent, "invite", new String[0]);
        this.itc = parent;
    }

    @Override
    public void setup() {
        this.setPermission("island.team.invite");
        this.setOnlyPlayer(true);
        this.setDescription("commands.island.team.invite.description");
        this.setConfigurableRankCommand();
        if (!new File(String.valueOf(this.getPlugin().getDataFolder()) + File.separator + "panels", "team_invite_panel.yml").exists()) {
            this.getPlugin().saveResource("panels/team_invite_panel.yml", false);
        }
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        UUID playerUUID = user.getUniqueId();
        IslandsManager islandsManager = this.getIslands();
        if (!islandsManager.inTeam(this.getWorld(), playerUUID) && !islandsManager.hasIsland(this.getWorld(), playerUUID)) {
            user.sendMessage("general.errors.no-island", new String[0]);
            return false;
        }
        Island island = islandsManager.getIsland(this.getWorld(), user);
        if (args.size() != 1) {
            new IslandTeamInviteGUI(this.itc, true, island).build(user);
            return false;
        }
        int rank = Objects.requireNonNull(island).getRank(user);
        return this.checkRankAndInvitePlayer(user, island, rank, args.getFirst());
    }

    private boolean checkRankAndInvitePlayer(User user, Island island, int rank, String playerName) {
        PlayersManager playersManager = this.getPlayers();
        UUID playerUUID = user.getUniqueId();
        int requiredRank = island.getRankCommand(this.getUsage());
        if (rank < requiredRank) {
            user.sendMessage("general.errors.insufficient-rank", "[rank]", user.getTranslation(RanksManager.getInstance().getRank(rank), new String[0]));
            return false;
        }
        int maxMembers = this.getIslands().getMaxMembers(island, 500);
        if (island.getMemberSet().size() >= maxMembers) {
            user.sendMessage("commands.island.team.invite.errors.island-is-full", new String[0]);
            return false;
        }
        UUID invitedPlayerUUID = playersManager.getUUID(playerName);
        if (invitedPlayerUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", playerName);
            return false;
        }
        this.invitedPlayer = User.getInstance(invitedPlayerUUID);
        if (!this.canInvitePlayer(user, this.invitedPlayer)) {
            return false;
        }
        if (this.getSettings().getInviteCooldown() > 0 && this.checkCooldown(user, island.getUniqueId(), invitedPlayerUUID.toString())) {
            return false;
        }
        if (this.getIWM().getWorldSettings(this.getWorld()).isDisallowTeamMemberIslands() && this.getIslands().inTeam(this.getWorld(), invitedPlayerUUID)) {
            user.sendMessage("commands.island.team.invite.errors.already-on-team", new String[0]);
            return false;
        }
        if (this.isInvitedByUser(invitedPlayerUUID, playerUUID) && this.isInviteTypeTeam(invitedPlayerUUID)) {
            user.sendMessage("commands.island.team.invite.errors.you-have-already-invited", new String[0]);
            return false;
        }
        return true;
    }

    private boolean canInvitePlayer(User user, User invitedPlayer) {
        UUID playerUUID = user.getUniqueId();
        if (!invitedPlayer.isOnline() || !user.getPlayer().canSee(invitedPlayer.getPlayer())) {
            user.sendMessage("general.errors.offline-player", new String[0]);
            return false;
        }
        if (playerUUID.equals(invitedPlayer.getUniqueId())) {
            user.sendMessage("commands.island.team.invite.errors.cannot-invite-self", new String[0]);
            return false;
        }
        return true;
    }

    private boolean isInvitedByUser(UUID invitedPlayerUUID, UUID inviterUUID) {
        return this.itc.isInvited(invitedPlayerUUID) && this.itc.getInviter(invitedPlayerUUID).equals(inviterUUID);
    }

    private boolean isInviteTypeTeam(UUID invitedPlayerUUID) {
        return Objects.requireNonNull(this.itc.getInvite(invitedPlayerUUID)).getType().equals((Object)TeamInvite.Type.TEAM);
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        Island island;
        if (this.invitedPlayer == null) {
            return false;
        }
        if (this.itc.isInvited(this.invitedPlayer.getUniqueId())) {
            this.itc.removeInvite(this.invitedPlayer.getUniqueId());
            user.sendMessage("commands.island.team.invite.removing-invite", new String[0]);
        }
        if ((island = this.getIslands().getIsland(this.getWorld(), user.getUniqueId())) == null) {
            user.sendMessage("general.errors.no-island", new String[0]);
            this.invitedPlayer = null;
            return false;
        }
        IslandBaseEvent e = TeamEvent.builder().island(island).reason(TeamEvent.Reason.INVITE).involvedPlayer(this.invitedPlayer.getUniqueId()).build();
        if (e.getNewEvent().map(IslandBaseEvent::isCancelled).orElse(e.isCancelled()).booleanValue()) {
            this.invitedPlayer = null;
            return false;
        }
        this.itc.addInvite(TeamInvite.Type.TEAM, user.getUniqueId(), this.invitedPlayer.getUniqueId(), island);
        user.sendMessage("commands.island.team.invite.invitation-sent", "[name]", this.invitedPlayer.getName(), "[display_name]", this.invitedPlayer.getDisplayName());
        this.invitedPlayer.sendMessage("commands.island.team.invite.name-has-invited-you", "[name]", user.getName(), "[display_name]", user.getDisplayName());
        this.invitedPlayer.sendMessage("commands.island.team.invite.to-accept-or-reject", "[label]", this.getTopLabel());
        if (this.getIWM().getWorldSettings(this.getWorld()).isDisallowTeamMemberIslands() && this.getIslands().hasIsland(this.getWorld(), this.invitedPlayer.getUniqueId())) {
            this.invitedPlayer.sendMessage("commands.island.team.invite.you-will-lose-your-island", new String[0]);
        }
        this.invitedPlayer = null;
        return true;
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        String lastArg;
        String string = lastArg = !args.isEmpty() ? args.getLast() : "";
        if (lastArg.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<String> options = new ArrayList<String>(Util.getOnlinePlayerList(user));
        return Optional.of(Util.tabLimit(options, lastArg));
    }
}

