/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.island;

import java.util.List;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.api.panels.builders.TabbedPanelBuilder;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.panels.settings.SettingsTab;
import world.bentobox.bentobox.util.Util;

public class IslandSettingsCommand
extends CompositeCommand {
    private Island island;

    public IslandSettingsCommand(CompositeCommand islandCommand) {
        super(islandCommand, "settings", "flags", "options");
    }

    @Override
    public void setup() {
        this.setPermission("island.settings");
        this.setOnlyPlayer(true);
        this.setDescription("commands.island.settings.description");
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        this.island = this.getWorld().equals((Object)Util.getWorld(user.getWorld())) ? this.getIslands().getIslandAt(user.getLocation()).orElseGet(() -> this.getIslands().getIsland(user.getWorld(), user.getUniqueId())) : this.getIslands().getIsland(this.getWorld(), user);
        if (this.island == null) {
            user.sendMessage("general.errors.no-island", new String[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        new TabbedPanelBuilder().user(user).island(this.island).world(this.island.getWorld()).tab(1, new SettingsTab(this.getWorld(), user, Flag.Type.PROTECTION)).tab(2, new SettingsTab(this.getWorld(), user, Flag.Type.SETTING)).startingSlot(1).size(54).build().openPanel();
        return true;
    }
}

