/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.island;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.ConfirmableCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.RanksManager;
import world.bentobox.bentobox.util.Util;

public class IslandDeletehomeCommand
extends ConfirmableCommand {
    public IslandDeletehomeCommand(CompositeCommand islandCommand) {
        super(islandCommand, "deletehome", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("island.deletehome");
        this.setOnlyPlayer(true);
        this.setParametersHelp("commands.island.deletehome.parameters");
        this.setDescription("commands.island.deletehome.description");
        this.setConfigurableRankCommand();
        this.setDefaultCommandRank(500);
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (args.isEmpty()) {
            this.showHelp(this, user);
            return false;
        }
        Island island = this.getIslands().getIsland(this.getWorld(), user);
        if (island == null) {
            user.sendMessage("general.errors.no-island", new String[0]);
            return false;
        }
        int rank = Objects.requireNonNull(island).getRank(user);
        if (rank < island.getRankCommand(this.getUsage())) {
            user.sendMessage("general.errors.insufficient-rank", "[rank]", user.getTranslation(RanksManager.getInstance().getRank(rank), new String[0]));
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        String name;
        Map<String, Island> map = this.getNameIslandMap(user);
        if (!map.containsKey(name = String.join((CharSequence)" ", args))) {
            user.sendMessage("commands.island.go.unknown-home", new String[0]);
            user.sendMessage("commands.island.sethome.homes-are", new String[0]);
            map.keySet().stream().filter(s -> !s.isEmpty()).forEach(s -> user.sendMessage("commands.island.sethome.home-list-syntax", "[name]", (String)s));
            return false;
        }
        this.askConfirmation(user, () -> this.delete((Island)map.get(name), user, name));
        return true;
    }

    private void delete(Island island, User user, String name) {
        island.removeHome(name);
        user.sendMessage("general.success", new String[0]);
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        String lastArg = !args.isEmpty() ? args.getLast() : "";
        return Optional.of(Util.tabLimit(new ArrayList<String>(this.getNameIslandMap(user).keySet()), lastArg));
    }

    private Map<String, Island> getNameIslandMap(User user) {
        HashMap<String, Island> islandMap = new HashMap<String, Island>();
        for (Island isle : this.getIslands().getIslands(this.getWorld(), user.getUniqueId())) {
            isle.getHomes().keySet().forEach(name -> islandMap.put((String)name, isle));
        }
        return islandMap;
    }
}

