/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin.team;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.ConfirmableCommand;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.events.team.TeamEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.Util;

public class AdminTeamSetownerCommand
extends ConfirmableCommand {
    private @Nullable UUID targetUUID;
    private Island island;
    private @Nullable UUID previousOwnerUUID;

    public AdminTeamSetownerCommand(CompositeCommand parent) {
        super(parent, "setowner", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("mod.team.setowner");
        this.setParametersHelp("commands.admin.team.setowner.parameters");
        this.setDescription("commands.admin.team.setowner.description");
        this.setOnlyPlayer(true);
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (args.size() != 1) {
            this.showHelp(this, user);
            return false;
        }
        this.targetUUID = Util.getUUID(args.getFirst());
        if (this.targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.getFirst());
            return false;
        }
        Optional<Island> opIsland = this.getIslands().getIslandAt(user.getLocation());
        if (opIsland.isEmpty()) {
            user.sendMessage("commands.admin.team.setowner.must-be-on-island", new String[0]);
            return false;
        }
        this.island = opIsland.get();
        this.previousOwnerUUID = this.island.getOwner();
        if (this.targetUUID.equals(this.previousOwnerUUID)) {
            user.sendMessage("commands.admin.team.setowner.already-owner", "[name]", args.getFirst());
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        Objects.requireNonNull(this.island);
        Objects.requireNonNull(this.targetUUID);
        this.askConfirmation(user, user.getTranslation("commands.admin.team.setowner.confirmation", "[name]", args.getFirst(), "[xyz]", Util.xyz(this.island.getCenter().toVector())), () -> this.changeOwner(user));
        return true;
    }

    protected void changeOwner(User user) {
        assert (this.targetUUID != null);
        User target = User.getInstance(this.targetUUID);
        TeamEvent.builder().island(this.island).reason(TeamEvent.Reason.SETOWNER).involvedPlayer(this.targetUUID).admin(true).build();
        IslandEvent.builder().island(this.island).involvedPlayer(this.targetUUID).admin(true).reason(IslandEvent.Reason.RANK_CHANGE).rankChange(this.island.getRank(target), 1000).build();
        this.getIslands().setOwner(user, this.targetUUID, this.island, 500);
        user.sendMessage("commands.admin.team.setowner.success", "[name]", target.getName());
        int num = this.getIslands().getNumberOfConcurrentIslands(this.targetUUID, this.getWorld());
        int max = target.getPermissionValue(this.getIWM().getAddon(this.getWorld()).map(Addon::getPermissionPrefix).orElse("") + "island.number", this.getIWM().getWorldSettings(this.getWorld()).getConcurrentIslands());
        if (num > max) {
            user.sendMessage("commands.admin.team.setowner.extra-islands", "[number]", String.valueOf(num), "[max]", String.valueOf(max));
        }
        if (this.previousOwnerUUID != null) {
            IslandEvent.builder().island(this.island).involvedPlayer(this.previousOwnerUUID).admin(true).reason(IslandEvent.Reason.RANK_CHANGE).rankChange(1000, this.island.getRank(this.previousOwnerUUID)).build();
        }
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        String lastArg = !args.isEmpty() ? args.getLast() : "";
        List<String> options = Bukkit.getOnlinePlayers().stream().map(Player::getName).toList();
        return Optional.of(Util.tabLimit(options, lastArg));
    }
}

