/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin.team;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.events.team.TeamEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.Util;

public class AdminTeamDisbandCommand
extends CompositeCommand {
    private Island island;
    private @Nullable UUID targetUUID;

    public AdminTeamDisbandCommand(CompositeCommand parent) {
        super(parent, "disband", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("mod.team.disband");
        this.setParametersHelp("commands.admin.team.disband.parameters");
        this.setDescription("commands.admin.team.disband.description");
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (args.isEmpty() || args.size() > 2) {
            this.showHelp(this, user);
            return false;
        }
        this.targetUUID = Util.getUUID(args.getFirst());
        if (this.targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.getFirst());
            return false;
        }
        Map<String, Island> islands = this.getIslandsXYZ(this.targetUUID);
        if (islands.isEmpty()) {
            user.sendMessage("general.errors.player-has-no-island", new String[0]);
            return false;
        }
        if (islands.size() > 1) {
            if (args.size() != 2 || !islands.containsKey(args.get(1))) {
                user.sendMessage("commands.admin.team.disband.more-than-one-island", "[name]", this.getPlayers().getName(this.island.getOwner()));
                islands.keySet().forEach(coords -> user.sendMessage("commands.admin.team.disband.more-than-one-island", "[xyz]", (String)coords));
                return false;
            }
            this.island = islands.get(args.get(1));
        } else {
            this.island = islands.values().iterator().next();
        }
        if (this.island.getOwner() == null || !this.island.getOwner().equals(this.targetUUID)) {
            user.sendMessage("general.errors.player-is-not-owner", "[name]", args.getFirst());
            return false;
        }
        return true;
    }

    private Map<String, Island> getIslandsXYZ(UUID target) {
        return this.getIslands().getOwnedIslands(this.getWorld(), target).stream().filter(is -> is.getMemberSet().size() > 1).collect(Collectors.toMap(is -> Util.xyz(is.getCenter().toVector()), is -> is));
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        Objects.requireNonNull(this.island);
        Objects.requireNonNull(this.targetUUID);
        this.island.getMemberSet().forEach(m -> {
            User mUser = User.getInstance(m);
            mUser.sendMessage("commands.admin.team.disband.disbanded", new String[0]);
            if (!m.equals(this.targetUUID)) {
                this.getIslands().removePlayer(this.island, (UUID)m);
                TeamEvent.builder().island(this.island).reason(TeamEvent.Reason.KICK).involvedPlayer((UUID)m).admin(true).build();
                IslandEvent.builder().island(this.island).involvedPlayer(this.targetUUID).admin(true).reason(IslandEvent.Reason.RANK_CHANGE).rankChange(this.island.getRank(mUser), 0).build();
            }
        });
        user.sendMessage("commands.admin.team.disband.success", "[name]", args.getFirst());
        return true;
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        UUID uuid;
        String lastArg;
        String string = lastArg = !args.isEmpty() ? args.getLast() : "";
        if (args.isEmpty()) {
            return Optional.empty();
        }
        if (args.size() == 3) {
            ArrayList<String> options = new ArrayList<String>(Util.getOnlinePlayerList(user));
            return Optional.of(Util.tabLimit(options, lastArg));
        }
        if (args.size() > 3 && (uuid = this.getPlayers().getUUID(args.get(1))) != null) {
            return Optional.of(Util.tabLimit(new ArrayList<String>(this.getIslandsXYZ(uuid).keySet()), lastArg));
        }
        return Optional.empty();
    }
}

