/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin.resets;

import java.util.List;
import java.util.UUID;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.util.Util;

public class AdminResetsSetCommand
extends CompositeCommand {
    public AdminResetsSetCommand(CompositeCommand parent) {
        super(parent, "set", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("admin.resets.set");
        this.setDescription("commands.admin.resets.set.description");
        this.setParametersHelp("commands.admin.resets.set.parameters");
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        if (args.size() != 2) {
            this.showHelp(this, user);
            return false;
        }
        UUID targetUUID = Util.getUUID(args.getFirst());
        if (targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.getFirst());
        } else if (!Util.isInteger(args.get(1), true) || Integer.parseInt(args.get(1)) <= 0) {
            user.sendMessage("general.errors.must-be-positive-number", "[number]", args.get(1));
        } else {
            this.getPlayers().setResets(this.getWorld(), targetUUID, Integer.parseInt(args.get(1)));
            user.sendMessage("commands.admin.resets.set.success", "[name]", args.getFirst(), "[number]", args.get(1));
            return true;
        }
        return false;
    }
}

