/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin.range;

import java.util.List;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.admin.range.AbstractAdminRangeCommand;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.util.Util;

public class AdminRangeSetCommand
extends AbstractAdminRangeCommand {
    public AdminRangeSetCommand(CompositeCommand parent) {
        super(parent, "set");
    }

    @Override
    public void setup() {
        this.setPermission("admin.range.set");
        this.setParametersHelp("commands.admin.range.set.parameters");
        this.setDescription("commands.admin.range.set.description");
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        if (!Util.isInteger(args.get(1), true) || Integer.parseInt(args.get(1)) < 0) {
            user.sendMessage("general.errors.must-be-positive-number", "[number]", args.get(1));
            return false;
        }
        int range = Integer.parseInt(args.get(1));
        if (range < 1) {
            user.sendMessage("commands.admin.range.invalid-value.too-low", "[number]", args.get(1));
            return false;
        }
        if (range > this.targetIsland.getRange() * 2) {
            user.sendMessage("commands.admin.range.invalid-value.too-high", "[number]", String.valueOf(2 * this.targetIsland.getRange()));
            return false;
        }
        if (range == this.targetIsland.getProtectionRange()) {
            user.sendMessage("commands.admin.range.invalid-value.same-as-before", "[number]", args.get(1));
            return false;
        }
        int oldRange = this.targetIsland.getProtectionRange();
        this.targetIsland.setProtectionRange(range);
        IslandEvent.builder().island(this.targetIsland).location(this.targetIsland.getCenter()).reason(IslandEvent.Reason.RANGE_CHANGE).involvedPlayer(this.targetUUID).admin(true).protectionRange(range, oldRange).build();
        user.sendMessage("commands.admin.range.set.success", "[number]", String.valueOf(range));
        return true;
    }
}

