/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin.purge;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.admin.purge.AdminPurgeProtectCommand;
import world.bentobox.bentobox.api.commands.admin.purge.AdminPurgeRegionsCommand;
import world.bentobox.bentobox.api.commands.admin.purge.AdminPurgeStatusCommand;
import world.bentobox.bentobox.api.commands.admin.purge.AdminPurgeStopCommand;
import world.bentobox.bentobox.api.commands.admin.purge.AdminPurgeUnownedCommand;
import world.bentobox.bentobox.api.events.island.IslandDeletedEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;

public class AdminPurgeCommand
extends CompositeCommand
implements Listener {
    private static final Long YEAR2000 = 946713600L;
    private static final int TOO_MANY = 1000;
    private int count;
    private boolean inPurge;
    private boolean scanning;
    private boolean toBeConfirmed;
    private Iterator<String> it;
    private User user;
    private Set<String> islands = new HashSet<String>();
    private final Set<Integer> loggedTiers = new HashSet<Integer>();

    public AdminPurgeCommand(CompositeCommand parent) {
        super(parent, "purge", new String[0]);
        ((Addon)this.getAddon()).registerListener(this);
    }

    @Override
    public void setup() {
        this.setPermission("admin.purge");
        this.setOnlyPlayer(false);
        this.setParametersHelp("commands.admin.purge.parameters");
        this.setDescription("commands.admin.purge.description");
        new AdminPurgeStatusCommand(this);
        new AdminPurgeStopCommand(this);
        new AdminPurgeUnownedCommand(this);
        new AdminPurgeProtectCommand(this);
        new AdminPurgeRegionsCommand(this);
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (this.scanning) {
            user.sendMessage("commands.admin.purge.scanning-in-progress", new String[0]);
            return false;
        }
        if (this.inPurge) {
            user.sendMessage("commands.admin.purge.purge-in-progress", "[label]", this.getTopLabel());
            return false;
        }
        if (args.isEmpty()) {
            this.showHelp(this, user);
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        if (args.getFirst().equalsIgnoreCase("confirm") && this.toBeConfirmed && this.user.equals(user)) {
            this.removeIslands();
            return true;
        }
        this.toBeConfirmed = false;
        this.islands.clear();
        this.user = user;
        try {
            int days = Integer.parseInt(args.getFirst());
            if (days < 1) {
                user.sendMessage("commands.admin.purge.days-one-or-more", new String[0]);
                return false;
            }
            user.sendMessage("commands.admin.purge.scanning", new String[0]);
            this.scanning = true;
            this.getOldIslands(days).thenAccept(islandSet -> {
                user.sendMessage("commands.admin.purge.purgable-islands", "[number]", String.valueOf(islandSet.size()));
                if (islandSet.size() > 1000 && !BentoBox.getInstance().getSettings().isKeepPreviousIslandOnReset()) {
                    user.sendMessage("commands.admin.purge.too-many", new String[0]);
                }
                if (!islandSet.isEmpty()) {
                    this.toBeConfirmed = true;
                    user.sendMessage("commands.admin.purge.confirm", "[label]", this.getTopLabel());
                    this.islands = islandSet;
                } else {
                    user.sendMessage("commands.admin.purge.none-found", new String[0]);
                }
                this.scanning = false;
            });
        }
        catch (NumberFormatException e) {
            user.sendMessage("commands.admin.purge.number-error", new String[0]);
            return false;
        }
        return true;
    }

    void removeIslands() {
        this.inPurge = true;
        this.user.sendMessage("commands.admin.purge.see-console-for-status", "[label]", this.getTopLabel());
        this.it = this.islands.iterator();
        this.count = 0;
        this.loggedTiers.clear();
        this.deleteIsland();
    }

    private void deleteIsland() {
        if (this.it.hasNext()) {
            this.getIslands().getIslandById(this.it.next()).ifPresent(i -> {
                this.getIslands().deleteIsland((Island)i, true, null);
                ++this.count;
                float percentage = (float)this.count / (float)this.getPurgeableIslandsCount() * 100.0f;
                String percentageStr = String.format("%.1f", Float.valueOf(percentage));
                int roundedPercentage = (int)Math.floor(percentage);
                if (!BentoBox.getInstance().getSettings().isKeepPreviousIslandOnReset() || roundedPercentage > 0 && (roundedPercentage == 1 || roundedPercentage % 5 == 0) && !this.loggedTiers.contains(roundedPercentage)) {
                    this.getPlugin().log(this.count + " islands purged out of " + this.getPurgeableIslandsCount() + " (" + percentageStr + " %)");
                    this.loggedTiers.add(roundedPercentage);
                }
            });
        } else {
            this.user.sendMessage("commands.admin.purge.completed", new String[0]);
            this.inPurge = false;
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    void onIslandDeleted(IslandDeletedEvent e) {
        if (this.inPurge) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.getPlugin(), this::deleteIsland, 2L);
        }
    }

    CompletableFuture<Set<String>> getOldIslands(int days) {
        CompletableFuture<Set<String>> result = new CompletableFuture<Set<String>>();
        this.getPlugin().getIslands().getIslandsASync().thenAccept(list -> {
            this.user.sendMessage("commands.admin.purge.total-islands", "[number]", String.valueOf(list.size()));
            HashSet oldIslands = new HashSet();
            list.stream().filter(i -> !i.isSpawn()).filter(i -> !i.isPurgeProtected()).filter(i -> i.getWorld() != null).filter(i -> i.getWorld().equals((Object)this.getWorld())).filter(Island::isOwned).filter(i -> i.getMemberSet().stream().allMatch(member -> this.checkLastLoginTimestamp(days, (UUID)member))).forEach(i -> oldIslands.add(i.getUniqueId()));
            result.complete(oldIslands);
        });
        return result;
    }

    private boolean checkLastLoginTimestamp(int days, UUID member) {
        long daysInMilliseconds = (long)days * 24L * 3600L * 1000L;
        Long lastLoginTimestamp = this.getPlayers().getLastLoginTimestamp(member);
        if (lastLoginTimestamp == null || lastLoginTimestamp < YEAR2000) {
            lastLoginTimestamp = Bukkit.getOfflinePlayer((UUID)member).getLastSeen();
            if (lastLoginTimestamp < YEAR2000) {
                this.getPlayers().setLoginTimeStamp(member, System.currentTimeMillis());
                return false;
            }
            this.getPlayers().setLoginTimeStamp(member, lastLoginTimestamp);
        }
        return System.currentTimeMillis() - lastLoginTimestamp > daysInMilliseconds;
    }

    boolean isInPurge() {
        return this.inPurge;
    }

    void stop() {
        this.inPurge = false;
    }

    void setUser(User user) {
        this.user = user;
    }

    void setIslands(Set<String> islands) {
        this.islands = islands;
    }

    int getPurgedIslandsCount() {
        return this.count;
    }

    int getPurgeableIslandsCount() {
        return this.islands.size();
    }
}

