/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.World;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.ConfirmableCommand;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;

public class AdminSetspawnCommand
extends ConfirmableCommand {
    public AdminSetspawnCommand(CompositeCommand parent) {
        super(parent, "setspawn", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("admin.setspawn");
        this.setOnlyPlayer(true);
        this.setDescription("commands.admin.setspawn.description");
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        Optional<Island> island = this.getIslands().getIslandAt(user.getLocation());
        if (island.isPresent()) {
            if (island.map(Island::isSpawn).orElse(false).booleanValue()) {
                user.sendMessage("commands.admin.setspawn.already-spawn", new String[0]);
            }
            this.askConfirmation(user, user.getTranslation("commands.admin.setspawn.confirmation", new String[0]), () -> this.setSpawn(user, (Island)island.get()));
            return true;
        }
        user.sendMessage("commands.admin.setspawn.no-island-here", new String[0]);
        return false;
    }

    private void setSpawn(User user, Island i) {
        if (!i.getMembers().isEmpty()) {
            if (i.isOwned()) {
                IslandEvent.builder().island(i).location(i.getCenter()).reason(IslandEvent.Reason.UNREGISTERED).involvedPlayer(i.getOwner()).admin(true).build();
            }
            new ImmutableSet.Builder().addAll(i.getMembers().keySet()).build().forEach(m -> this.getIslands().removePlayer(i, (UUID)m));
        }
        this.getIslands().setSpawn(i);
        i.setSpawnPoint(World.Environment.NORMAL, user.getLocation());
        i.setProtectionRange(i.getRange() * 2);
        user.sendMessage("commands.admin.setspawn.success", new String[0]);
    }
}

