/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.entity.Player;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.Settings;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.commands.BentoBoxCommand;
import world.bentobox.bentobox.api.commands.DefaultHelpCommand;
import world.bentobox.bentobox.api.events.command.CommandEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.IslandWorldManager;
import world.bentobox.bentobox.managers.IslandsManager;
import world.bentobox.bentobox.managers.PlayersManager;
import world.bentobox.bentobox.util.Util;

public abstract class CompositeCommand
extends Command
implements PluginIdentifiableCommand,
BentoBoxCommand {
    private static final String COMMANDS = "commands.";
    private final BentoBox plugin;
    private boolean onlyPlayer = false;
    private boolean onlyConsole = false;
    private boolean configurableRankCommand = false;
    private boolean hidden = false;
    private String parameters = "";
    private String permission = "";
    private int defaultCommandRank = 1000;
    protected final CompositeCommand parent;
    private final int subCommandLevel;
    private final Map<String, CompositeCommand> subCommands;
    private final Map<String, CompositeCommand> subCommandAliases;
    private String usage;
    private final String topLabel;
    private final @Nullable String permissionPrefix;
    private World world;
    private final Addon addon;
    private final Map<String, Map<String, Long>> cooldowns = new HashMap<String, Map<String, Long>>();

    protected CompositeCommand(Addon addon, String label, String ... aliases) {
        super(label, "", "", Arrays.asList(aliases));
        this.addon = addon;
        this.topLabel = label;
        this.plugin = BentoBox.getInstance();
        this.setAliases(new ArrayList<String>(Arrays.asList(aliases)));
        this.parent = null;
        this.setUsage("");
        this.subCommandLevel = 0;
        this.subCommands = new LinkedHashMap<String, CompositeCommand>();
        this.subCommandAliases = new LinkedHashMap<String, CompositeCommand>();
        if (this.plugin.getCommand(label) == null) {
            this.plugin.getCommandsManager().registerCommand(this);
        }
        this.setDescription(COMMANDS + label + ".description");
        this.setParametersHelp(COMMANDS + label + ".parameters");
        this.permissionPrefix = addon != null ? addon.getPermissionPrefix() : "";
        this.setup();
        if (this.getSubCommand("help").isEmpty() && !label.equals("help")) {
            new DefaultHelpCommand(this);
        }
    }

    protected CompositeCommand(String label, String ... aliases) {
        this((Addon)null, label, aliases);
    }

    protected CompositeCommand(CompositeCommand parent, String label, String ... aliases) {
        this((Addon)parent.getAddon(), parent, label, aliases);
    }

    protected CompositeCommand(Addon addon, CompositeCommand parent, String label, String ... aliases) {
        super(label, "", "", Arrays.asList(aliases));
        this.topLabel = parent.getTopLabel();
        this.plugin = BentoBox.getInstance();
        this.addon = addon;
        this.parent = parent;
        this.subCommandLevel = parent.getLevel() + 1;
        parent.getSubCommands().put(label.toLowerCase(Locale.ENGLISH), this);
        this.setAliases(new ArrayList<String>(Arrays.asList(aliases)));
        this.subCommands = new LinkedHashMap<String, CompositeCommand>();
        this.subCommandAliases = new LinkedHashMap<String, CompositeCommand>();
        for (String alias : aliases) {
            parent.getSubCommandAliases().put(alias.toLowerCase(Locale.ENGLISH), this);
        }
        this.setUsage("");
        this.permissionPrefix = parent.getPermissionPrefix();
        StringBuilder reference = new StringBuilder();
        reference.append(label);
        CompositeCommand p = this;
        for (int index = 0; p.getParent() != null && index < 20; ++index) {
            reference.insert(0, p.getParent().getLabel() + ".");
            p = p.getParent();
        }
        this.setDescription(COMMANDS + String.valueOf(reference) + ".description");
        this.setParametersHelp(COMMANDS + String.valueOf(reference) + ".parameters");
        this.setup();
        if (this.getSubCommand("help").isEmpty() && !label.equals("help")) {
            new DefaultHelpCommand(this);
        }
    }

    public boolean execute(@NonNull CommandSender sender, @NonNull String label, String[] args) {
        User user = User.getInstance(sender);
        CommandEvent event = CommandEvent.builder().setCommand(this).setLabel(label).setSender(sender).setArgs(args).build();
        if (event.isCancelled()) {
            return false;
        }
        CompositeCommand cmd = this.getCommandFromArgs(args);
        String cmdLabel = cmd.subCommandLevel > 0 ? args[cmd.subCommandLevel - 1] : label;
        List<String> cmdArgs = Arrays.asList(args).subList(cmd.subCommandLevel, args.length);
        return cmd.call(user, cmdLabel, cmdArgs);
    }

    public boolean call(User user, String cmdLabel, List<String> cmdArgs) {
        if (this.isOnlyPlayer() && !user.isPlayer()) {
            user.sendMessage("general.errors.use-in-game", new String[0]);
            return false;
        }
        if (this.isOnlyConsole() && user.isPlayer()) {
            user.sendMessage("general.errors.use-in-console", new String[0]);
            return false;
        }
        if (!this.runPermissionCheck(user)) {
            return false;
        }
        user.setAddon(this.addon);
        return this.canExecute(user, cmdLabel, cmdArgs) && this.execute(user, cmdLabel, cmdArgs);
    }

    private boolean runPermissionCheck(User user) {
        if (user.isPlayer() && !user.isOp() && this.getPermission() != null && !this.getPermission().isEmpty() && !user.hasPermission(this.getPermission())) {
            user.sendMessage("general.errors.no-permission", "[permission]", this.getPermission());
            return false;
        }
        return this.getParent() == null || this.getParent().runPermissionCheck(user);
    }

    private CompositeCommand getCommandFromArgs(String[] args) {
        CompositeCommand subCommand = this;
        for (String arg : args) {
            Optional<CompositeCommand> sub;
            if (subCommand.hasSubCommands()) {
                sub = subCommand.getSubCommand(arg);
                if (sub.isEmpty()) {
                    return subCommand;
                }
            } else {
                return subCommand;
            }
            subCommand = sub.orElse(subCommand);
            subCommand.setLabel(arg);
        }
        return subCommand;
    }

    public IslandsManager getIslands() {
        return this.plugin.getIslands();
    }

    protected IslandsManager getIslandsManager() {
        return this.plugin.getIslandsManager();
    }

    protected int getLevel() {
        return this.subCommandLevel;
    }

    public Logger getLogger() {
        return this.plugin.getLogger();
    }

    protected Set<UUID> getMembers(World world, User user) {
        Island island = this.plugin.getIslands().getIsland(world, user);
        if (island == null) {
            return Set.of();
        }
        return island.getMemberSet();
    }

    public String getParameters() {
        return this.parameters;
    }

    public CompositeCommand getParent() {
        return this.parent;
    }

    public String getPermission() {
        return this.permission;
    }

    protected PlayersManager getPlayers() {
        return this.plugin.getPlayers();
    }

    public @NonNull BentoBox getPlugin() {
        return this.plugin;
    }

    public IslandWorldManager getIWM() {
        return this.plugin.getIWM();
    }

    public Settings getSettings() {
        return this.plugin.getSettings();
    }

    public Optional<CompositeCommand> getSubCommand(String label) {
        if (this.subCommands.containsKey(label = label.toLowerCase(Locale.ENGLISH))) {
            return Optional.ofNullable(this.subCommands.get(label));
        }
        if (this.subCommandAliases.containsKey(label)) {
            return Optional.ofNullable(this.subCommandAliases.get(label));
        }
        return Optional.empty();
    }

    public Map<String, CompositeCommand> getSubCommands() {
        return this.subCommands;
    }

    public Map<String, CompositeCommand> getSubCommands(boolean ignoreHelp) {
        if (ignoreHelp && this.getSubCommand("help").isPresent()) {
            Map<String, CompositeCommand> result = this.subCommands;
            result.remove("help");
            return result;
        }
        return this.getSubCommands();
    }

    public @NonNull String getUsage() {
        return "/" + this.usage;
    }

    protected boolean hasSubCommand(String subCommand) {
        return this.subCommands.containsKey(subCommand) || this.subCommandAliases.containsKey(subCommand);
    }

    protected boolean hasSubCommands() {
        return !this.subCommands.isEmpty();
    }

    protected boolean hasSubCommands(boolean ignoreHelp) {
        return !this.getSubCommands(ignoreHelp).isEmpty();
    }

    protected boolean inTeam(World world, User user) {
        return this.plugin.getIslands().inTeam(world, user.getUniqueId());
    }

    public boolean isOnlyPlayer() {
        return this.onlyPlayer;
    }

    public boolean isOnlyConsole() {
        return this.onlyConsole;
    }

    public void setOnlyPlayer(boolean onlyPlayer) {
        this.onlyPlayer = onlyPlayer;
    }

    public void setOnlyConsole(boolean onlyConsole) {
        this.onlyConsole = onlyConsole;
    }

    public @NonNull Command setDescription(@NonNull String description) {
        super.setDescription(description);
        return this;
    }

    public void setParametersHelp(String parametersHelp) {
        this.parameters = parametersHelp;
    }

    public void setPermission(String permission) {
        this.permission = (this.permissionPrefix != null && !this.permissionPrefix.isEmpty() ? this.permissionPrefix : "") + permission;
    }

    public void inheritPermission() {
        this.permission = this.parent.getPermission();
    }

    public @NonNull Command setUsage(@NonNull String usage) {
        StringBuilder u = new StringBuilder().append(this.getLabel()).append(" ").append(usage);
        for (CompositeCommand parentCommand = this.getParent(); parentCommand != null; parentCommand = parentCommand.getParent()) {
            u.insert(0, " ");
            u.insert(0, parentCommand.getLabel());
        }
        this.usage = u.toString().trim();
        return this;
    }

    public @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String alias, String[] args) {
        CompositeCommand command = this.getCommandFromArgs(args);
        if (command.isOnlyPlayer() && !(sender instanceof Player) || command.isOnlyConsole() && sender instanceof Player) {
            return List.of();
        }
        if (!(command.getPermission() == null || command.getPermission().isEmpty() || sender.hasPermission(command.getPermission()) || sender.isOp())) {
            return List.of();
        }
        ArrayList<String> options = new ArrayList<String>(command.tabComplete(User.getInstance(sender), alias, new LinkedList<String>(Arrays.asList(args))).orElseGet(ArrayList::new));
        if (command.hasSubCommands()) {
            options.addAll(this.getSubCommandLabels(sender, command));
        }
        if (Arrays.asList(args).contains("help")) {
            options.remove("help");
        }
        String lastArg = args.length != 0 ? args[args.length - 1] : "";
        return Util.tabLimit(options, lastArg).stream().sorted().toList();
    }

    private @NonNull List<String> getSubCommandLabels(@NonNull CommandSender sender, @NonNull CompositeCommand command) {
        ArrayList<String> result = new ArrayList<String>();
        for (CompositeCommand cc : command.getSubCommands().values()) {
            if (sender instanceof Player) {
                if (cc.isHidden() || cc.isOnlyConsole() || !cc.getPermission().isEmpty() && !sender.hasPermission(cc.getPermission())) continue;
                result.add(cc.getLabel());
                continue;
            }
            if (cc.isOnlyPlayer()) continue;
            result.add(cc.getLabel());
        }
        return result;
    }

    public boolean showHelp(CompositeCommand command, User user) {
        return command.getSubCommand("help").map(helpCommand -> helpCommand.execute(user, helpCommand.getLabel(), new ArrayList())).orElse(false);
    }

    public Map<String, CompositeCommand> getSubCommandAliases() {
        return this.subCommandAliases;
    }

    public @Nullable String getPermissionPrefix() {
        return this.permissionPrefix;
    }

    public World getWorld() {
        return this.parent != null ? this.parent.getWorld() : this.world;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public <T extends Addon> T getAddon() {
        return (T)this.addon;
    }

    public String getTopLabel() {
        return this.topLabel;
    }

    public void setCooldown(String uniqueId, String targetUUID, int timeInSeconds) {
        this.cooldowns.computeIfAbsent(uniqueId, k -> new HashMap()).put(targetUUID, System.currentTimeMillis() + (long)timeInSeconds * 1000L);
    }

    public void setCooldown(UUID uniqueId, UUID targetUUID, int timeInSeconds) {
        this.cooldowns.computeIfAbsent(uniqueId.toString(), k -> new HashMap()).put(targetUUID == null ? null : targetUUID.toString(), System.currentTimeMillis() + (long)timeInSeconds * 1000L);
    }

    public void setCooldown(UUID uniqueId, int timeInSeconds) {
        this.setCooldown(uniqueId, null, timeInSeconds);
    }

    protected boolean checkCooldown(User user, UUID targetUUID) {
        return this.checkCooldown(user, user.getUniqueId().toString(), targetUUID == null ? null : targetUUID.toString());
    }

    protected boolean checkCooldown(User user) {
        return this.checkCooldown(user, user.getUniqueId().toString(), null);
    }

    protected boolean checkCooldown(User user, String uniqueId, String targetUUID) {
        if (!this.cooldowns.containsKey(uniqueId) || user.isOp() || user.hasPermission(this.getPermissionPrefix() + "mod.bypasscooldowns")) {
            return false;
        }
        this.cooldowns.putIfAbsent(uniqueId, new HashMap());
        if (this.cooldowns.get(uniqueId).getOrDefault(targetUUID, 0L) - System.currentTimeMillis() <= 0L) {
            this.cooldowns.get(uniqueId).remove(targetUUID);
            return false;
        }
        int timeToGo = (int)((this.cooldowns.get(uniqueId).getOrDefault(targetUUID, 0L) - System.currentTimeMillis()) / 1000L);
        user.sendMessage("general.errors.you-must-wait", "[number]", String.valueOf(timeToGo));
        return true;
    }

    public boolean isConfigurableRankCommand() {
        return this.configurableRankCommand;
    }

    public void setConfigurableRankCommand() {
        this.configurableRankCommand = true;
    }

    public void setDefaultCommandRank(int rank) {
        this.defaultCommandRank = rank;
    }

    public int getDefaultCommandRank() {
        return this.defaultCommandRank;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }
}

