/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.addons;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import org.bukkit.plugin.java.JavaPlugin;
import world.bentobox.bentobox.api.addons.Addon;

public abstract class Pladdon
extends JavaPlugin {
    private static final String ADDONS_FOLDER = "BentoBox" + File.separator + "addons";

    public abstract Addon getAddon();

    public void onLoad() {
        String parentFolder = this.getFile().getParent();
        if (parentFolder == null || !parentFolder.endsWith(ADDONS_FOLDER)) {
            // empty if block
        }
    }

    public void onDisable() {
        Addon addon = this.getAddon();
        if (addon != null) {
            addon.onDisable();
        }
    }

    protected void moveJar() {
        this.getLogger().severe(this.getFile().getName() + " must be in the " + ADDONS_FOLDER + " folder! Trying to move it there...");
        File addons = new File(this.getFile().getParent(), ADDONS_FOLDER);
        if (addons.exists() || addons.mkdirs()) {
            File to = new File(addons, this.getFile().getName());
            if (!to.exists()) {
                try {
                    Files.move((File)this.getFile(), (File)to);
                    this.getLogger().severe(this.getFile().getName() + " moved successfully.");
                }
                catch (IOException ex) {
                    this.getLogger().severe("Failed to move it. " + ex.getMessage());
                    this.getLogger().severe("Move " + this.getFile().getName() + " manually into the " + ADDONS_FOLDER + " folder. Then restart server.");
                }
            } else {
                this.getLogger().warning(this.getFile().getName() + " already is in the addons folder. Delete the one in the plugins folder.");
            }
        } else {
            this.getLogger().severe("BentoBox addons folder could not be made! " + addons.getAbsolutePath());
        }
    }

    public void setEnabled() {
        this.setEnabled(true);
    }
}

