/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.addons;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class AddonDescription {
    private final @NonNull String main;
    private final @NonNull String name;
    private final @NonNull String version;
    private final @NonNull String description;
    private final @NonNull List<String> authors;
    private final @NonNull List<String> dependencies;
    private final @NonNull List<String> softDependencies;
    private final @Nullable ConfigurationSection permissions;
    private final boolean metrics;
    private final @NonNull String repository;
    private final @NonNull Material icon;
    private final @NonNull String apiVersion;

    private AddonDescription(@NonNull Builder builder) {
        this.main = builder.main;
        this.name = builder.name;
        this.version = builder.version;
        this.description = builder.description;
        this.authors = builder.authors;
        this.dependencies = builder.dependencies;
        this.softDependencies = builder.softDependencies;
        this.metrics = builder.metrics;
        this.repository = builder.repository;
        this.icon = builder.icon;
        this.apiVersion = builder.apiVersion;
        this.permissions = builder.permissions;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull String getMain() {
        return this.main;
    }

    public @NonNull String getVersion() {
        return this.version;
    }

    public @NonNull String getDescription() {
        return this.description;
    }

    public @NonNull List<String> getAuthors() {
        return this.authors;
    }

    public @NonNull List<String> getDependencies() {
        return this.dependencies;
    }

    public @NonNull List<String> getSoftDependencies() {
        return this.softDependencies;
    }

    public boolean isMetrics() {
        return this.metrics;
    }

    public @NonNull String getRepository() {
        return this.repository;
    }

    public @NonNull Material getIcon() {
        return this.icon;
    }

    public @NonNull String getApiVersion() {
        return this.apiVersion;
    }

    public @Nullable ConfigurationSection getPermissions() {
        return this.permissions;
    }

    public String toString() {
        return "AddonDescription [name=" + this.name + ", version=" + this.version + "]";
    }

    public static class Builder {
        private final @NonNull String main;
        private final @NonNull String name;
        private final @NonNull String version;
        private @NonNull String description = "";
        private @NonNull List<String> authors = new ArrayList<String>();
        private @NonNull List<String> dependencies = new ArrayList<String>();
        private @NonNull List<String> softDependencies = new ArrayList<String>();
        private boolean metrics = true;
        private @NonNull String repository = "";
        private @NonNull Material icon = Material.PAPER;
        private @NonNull String apiVersion = "1";
        private @Nullable ConfigurationSection permissions;

        public Builder(@NonNull String main, @NonNull String name, @NonNull String version) {
            this.main = main;
            this.name = name;
            this.version = version;
        }

        public @NonNull Builder description(@NonNull String description) {
            this.description = description;
            return this;
        }

        public @NonNull Builder authors(String ... authors) {
            this.authors = Arrays.asList(authors);
            return this;
        }

        public @NonNull Builder dependencies(@NonNull List<String> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        public @NonNull Builder softDependencies(@NonNull List<String> softDependencies) {
            this.softDependencies = softDependencies;
            return this;
        }

        public @NonNull Builder metrics(boolean metrics) {
            this.metrics = metrics;
            return this;
        }

        public @NonNull Builder repository(@NonNull String repository) {
            this.repository = repository;
            return this;
        }

        public @NonNull Builder icon(@NonNull Material icon) {
            this.icon = icon;
            return this;
        }

        public @NonNull Builder apiVersion(@NonNull String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public @NonNull AddonDescription build() {
            return new AddonDescription(this);
        }

        public @NonNull Builder permissions(ConfigurationSection permissions) {
            this.permissions = permissions;
            return this;
        }
    }
}

