/*
 * Decompiled with CFR 0.152.
 */
package com.beepsterr.betterkeepinventory.api.Types;

import com.beepsterr.betterkeepinventory.api.Exceptions.TypeError;
import java.util.ArrayList;
import java.util.List;

public class SlotType {
    public static int[] armorSlots = new int[]{36, 37, 38, 39};
    public static int[] hotbarSlots = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    public static int[] offhandSlots = new int[]{40};
    public static int[] inventorySlots = new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35};
    private List<Integer> slotIds = new ArrayList<Integer>();

    public SlotType(List<String> slots) {
        block17: for (String slot : slots) {
            try {
                int slotId = Integer.parseInt(slot = slot.trim());
                if (slotId < 0 || slotId >= 41) continue;
                this.slotIds.add(slotId);
            }
            catch (Exception e) {
                switch (slot.toUpperCase()) {
                    case "ARMOR": {
                        for (int armorSlot : armorSlots) {
                            this.slotIds.add(armorSlot);
                        }
                        continue block17;
                    }
                    case "HOTBAR": {
                        for (int hotbarSlot : hotbarSlots) {
                            this.slotIds.add(hotbarSlot);
                        }
                        continue block17;
                    }
                    case "INVENTORY": {
                        for (int inventorySlot : inventorySlots) {
                            this.slotIds.add(inventorySlot);
                        }
                        continue block17;
                    }
                    case "OFFHAND": {
                        for (int offhandSlot : offhandSlots) {
                            this.slotIds.add(offhandSlot);
                        }
                        continue block17;
                    }
                    case "ALL": 
                    case "*": {
                        for (int i = 0; i < 41; ++i) {
                            this.slotIds.add(i);
                        }
                        continue block17;
                    }
                    default: {
                        throw new TypeError("Tried to parse invalid slot type: " + slot + ". Valid types are: ARMOR, HOTBAR, INVENTORY, OFFHAND, ALL or a number between 0 and 40.");
                    }
                }
            }
        }
        if (this.slotIds.isEmpty()) {
            for (int i = 0; i < 41; ++i) {
                this.slotIds.add(i);
            }
        }
    }

    public List<Integer> getSlotIds() {
        return this.slotIds;
    }
}

