/*
 * Decompiled with CFR 0.152.
 */
package com.beepsterr.betterkeepinventory.api.Types;

import com.beepsterr.betterkeepinventory.api.Exceptions.TypeError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MaterialType {
    public static Material[] RESOURCE_NETHERITE = new Material[]{Material.NETHERITE_SCRAP, Material.NETHERITE_INGOT, Material.NETHERITE_BLOCK, Material.ANCIENT_DEBRIS};
    public static Material[] RESOURCE_DIAMOND = new Material[]{Material.DIAMOND, Material.DIAMOND_ORE, Material.DEEPSLATE_DIAMOND_ORE, Material.DIAMOND_BLOCK};
    public static Material[] RESOURCE_GOLD = new Material[]{Material.GOLD_ORE, Material.DEEPSLATE_GOLD_ORE, Material.RAW_GOLD, Material.RAW_GOLD_BLOCK, Material.GOLD_NUGGET, Material.GOLD_INGOT, Material.GOLD_BLOCK};
    public static Material[] RESOURCE_IRON = new Material[]{Material.IRON_ORE, Material.DEEPSLATE_IRON_ORE, Material.RAW_IRON, Material.RAW_IRON_BLOCK, Material.IRON_NUGGET, Material.IRON_INGOT, Material.IRON_BLOCK};
    public static Material[] RESOURCE_COPPER = new Material[]{Material.COPPER_ORE, Material.DEEPSLATE_COPPER_ORE, Material.RAW_COPPER, Material.RAW_COPPER_BLOCK, Material.COPPER_INGOT, Material.COPPER_BLOCK, Material.WAXED_COPPER_BLOCK};
    public static Material[] RESOURCE_MISC = new Material[]{Material.EMERALD, Material.EMERALD_ORE, Material.DEEPSLATE_EMERALD_ORE, Material.EMERALD_BLOCK, Material.LAPIS_LAZULI, Material.LAPIS_ORE, Material.DEEPSLATE_LAPIS_ORE, Material.LAPIS_BLOCK, Material.COAL, Material.COAL_ORE, Material.DEEPSLATE_COAL_ORE, Material.COAL_BLOCK, Material.REDSTONE, Material.REDSTONE_ORE, Material.DEEPSLATE_REDSTONE_ORE, Material.REDSTONE_BLOCK, Material.QUARTZ, Material.NETHER_QUARTZ_ORE};
    public static final Material[] RESOURCES = (Material[])Stream.of(RESOURCE_COPPER, RESOURCE_IRON, RESOURCE_GOLD, RESOURCE_DIAMOND, RESOURCE_NETHERITE, RESOURCE_MISC).flatMap(Arrays::stream).toArray(Material[]::new);
    public static Material[] ARMOR = new Material[]{Material.LEATHER_HELMET, Material.LEATHER_CHESTPLATE, Material.LEATHER_LEGGINGS, Material.LEATHER_BOOTS, Material.CHAINMAIL_HELMET, Material.CHAINMAIL_CHESTPLATE, Material.CHAINMAIL_LEGGINGS, Material.CHAINMAIL_BOOTS, Material.IRON_HELMET, Material.IRON_CHESTPLATE, Material.IRON_LEGGINGS, Material.IRON_BOOTS, Material.GOLDEN_HELMET, Material.GOLDEN_CHESTPLATE, Material.GOLDEN_LEGGINGS, Material.GOLDEN_BOOTS, Material.DIAMOND_HELMET, Material.DIAMOND_CHESTPLATE, Material.DIAMOND_LEGGINGS, Material.DIAMOND_BOOTS, Material.NETHERITE_HELMET, Material.NETHERITE_CHESTPLATE, Material.NETHERITE_LEGGINGS, Material.NETHERITE_BOOTS};
    public static Material[] WEAPONS = new Material[]{Material.WOODEN_SWORD, Material.STONE_SWORD, Material.IRON_SWORD, Material.GOLDEN_SWORD, Material.DIAMOND_SWORD, Material.NETHERITE_SWORD, Material.BOW, Material.CROSSBOW, Material.TRIDENT};
    public static Material[] SWORDS = new Material[]{Material.WOODEN_SWORD, Material.STONE_SWORD, Material.IRON_SWORD, Material.GOLDEN_SWORD, Material.DIAMOND_SWORD, Material.NETHERITE_SWORD};
    public static Material[] AXES = new Material[]{Material.WOODEN_AXE, Material.STONE_AXE, Material.IRON_AXE, Material.GOLDEN_AXE, Material.DIAMOND_AXE, Material.NETHERITE_AXE};
    public static Material[] PICKAXES = new Material[]{Material.WOODEN_PICKAXE, Material.STONE_PICKAXE, Material.IRON_PICKAXE, Material.GOLDEN_PICKAXE, Material.DIAMOND_PICKAXE, Material.NETHERITE_PICKAXE};
    public static Material[] SHOVELS = new Material[]{Material.WOODEN_SHOVEL, Material.STONE_SHOVEL, Material.IRON_SHOVEL, Material.GOLDEN_SHOVEL, Material.DIAMOND_SHOVEL, Material.NETHERITE_SHOVEL};
    public static Material[] HOES = new Material[]{Material.WOODEN_HOE, Material.STONE_HOE, Material.IRON_HOE, Material.GOLDEN_HOE, Material.DIAMOND_HOE, Material.NETHERITE_HOE};
    public static Material[] POTIONS = new Material[]{Material.POTION, Material.SPLASH_POTION, Material.LINGERING_POTION};
    public static Material[] MISC_TOOLS = new Material[]{Material.FISHING_ROD, Material.SHEARS, Material.FLINT_AND_STEEL};
    public static Material[] TOOLS = (Material[])Stream.of(AXES, PICKAXES, SHOVELS, HOES, MISC_TOOLS).flatMap(Arrays::stream).toArray(Material[]::new);
    public static Material[] EQUIPMENT = (Material[])Stream.of(ARMOR, WEAPONS, TOOLS).flatMap(Arrays::stream).toArray(Material[]::new);
    private List<Material> materials = new ArrayList<Material>();
    private boolean includeAll = false;

    public MaterialType(List<String> materialConfig) {
        block38: for (String materialName : materialConfig) {
            materialName = materialName.trim().toUpperCase();
            try {
                Material material = Material.valueOf((String)materialName);
                if (!material.isItem()) continue;
                this.materials.add(material);
            }
            catch (IllegalArgumentException e) {
                String groupName;
                if (materialName.equals("*") || materialName.equals("ALL")) {
                    this.includeAll = true;
                    continue;
                }
                if (!materialName.startsWith("G:")) continue;
                switch (groupName = materialName.substring(2).toUpperCase()) {
                    case "RESOURCES": {
                        this.materials.addAll(List.of(RESOURCES));
                        continue block38;
                    }
                    case "NETHERITE": {
                        this.materials.addAll(List.of(RESOURCE_NETHERITE));
                        continue block38;
                    }
                    case "DIAMOND": {
                        this.materials.addAll(List.of(RESOURCE_DIAMOND));
                        continue block38;
                    }
                    case "GOLD": {
                        this.materials.addAll(List.of(RESOURCE_GOLD));
                        continue block38;
                    }
                    case "IRON": {
                        this.materials.addAll(List.of(RESOURCE_IRON));
                        continue block38;
                    }
                    case "COPPER": {
                        this.materials.addAll(List.of(RESOURCE_COPPER));
                        continue block38;
                    }
                    case "TOOLS": {
                        this.materials.addAll(List.of(TOOLS));
                        continue block38;
                    }
                    case "WEAPONS": {
                        this.materials.addAll(List.of(WEAPONS));
                        continue block38;
                    }
                    case "SWORDS": {
                        this.materials.addAll(List.of(SWORDS));
                        continue block38;
                    }
                    case "AXES": {
                        this.materials.addAll(List.of(AXES));
                        continue block38;
                    }
                    case "PICKAXES": {
                        this.materials.addAll(List.of(PICKAXES));
                        continue block38;
                    }
                    case "SHOVELS": {
                        this.materials.addAll(List.of(SHOVELS));
                        continue block38;
                    }
                    case "HOES": {
                        this.materials.addAll(List.of(HOES));
                        continue block38;
                    }
                    case "ARMOR": {
                        this.materials.addAll(List.of(ARMOR));
                        continue block38;
                    }
                    case "EQUIPMENT": {
                        this.materials.addAll(List.of(EQUIPMENT));
                        continue block38;
                    }
                    case "POTIONS": {
                        this.materials.addAll(List.of(POTIONS));
                        continue block38;
                    }
                }
                throw new TypeError("Tried to parse invalid material: " + materialName);
            }
        }
    }

    public boolean isIncludeAll() {
        return this.includeAll;
    }

    public List<Material> getMaterials() {
        return this.materials;
    }

    public static String GetName(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        String displayName = meta != null && meta.hasDisplayName() ? meta.getDisplayName() : Arrays.stream(item.getType().toString().split("_")).map(part -> part.substring(0, 1).toUpperCase() + part.substring(1).toLowerCase()).collect(Collectors.joining(" "));
        return displayName;
    }
}

