/*
 * Decompiled with CFR 0.152.
 */
package com.beepsterr.betterkeepinventory.Registries;

import com.beepsterr.betterkeepinventory.api.Effect;
import com.beepsterr.betterkeepinventory.api.Factory.EffectFactory;
import com.beepsterr.betterkeepinventory.api.Registries.EffectRegistry;
import com.beepsterr.betterkeepinventory.api.RegistryEntry;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public class PluginEffectRegistry
implements EffectRegistry {
    private final Map<String, RegistryEntry<EffectFactory>> factories = new HashMap<String, RegistryEntry<EffectFactory>>();

    @Override
    public void register(Plugin plugin, String key, EffectFactory factory) {
        RegistryEntry<EffectFactory> entry = new RegistryEntry<EffectFactory>(plugin, factory);
        String baseKey = key.toLowerCase();
        String namespacedKey = (plugin.getName() + "." + key).toLowerCase();
        if (!this.has(baseKey)) {
            this.factories.put(baseKey, entry);
        }
        this.factories.put(namespacedKey, entry);
    }

    @Override
    public boolean has(String key) {
        return this.factories.containsKey(key.toLowerCase());
    }

    @Override
    public EffectFactory get(String key) {
        return this.getFull(key).entry();
    }

    @Override
    public RegistryEntry<EffectFactory> getFull(String key) {
        return this.factories.get(key.toLowerCase());
    }

    @Override
    public Map<String, RegistryEntry<EffectFactory>> getAll() {
        return Collections.unmodifiableMap(this.factories);
    }

    @Override
    public Effect create(String key, ConfigurationSection config) {
        RegistryEntry<EffectFactory> factory = this.factories.get(key.toLowerCase());
        if (factory == null) {
            return null;
        }
        return factory.entry().create(config);
    }
}

