/*
 * Decompiled with CFR 0.152.
 */
package com.beepsterr.betterkeepinventory.Registries;

import com.beepsterr.betterkeepinventory.api.Factory.ConditionFactory;
import com.beepsterr.betterkeepinventory.api.Registries.ConditionRegistry;
import com.beepsterr.betterkeepinventory.api.RegistryEntry;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.plugin.Plugin;

public class PluginConditionRegistry
implements ConditionRegistry {
    private final Map<String, RegistryEntry<ConditionFactory>> conditions = new HashMap<String, RegistryEntry<ConditionFactory>>();

    @Override
    public void register(Plugin plugin, String key, ConditionFactory condition) {
        RegistryEntry<ConditionFactory> entry = new RegistryEntry<ConditionFactory>(plugin, condition);
        String baseKey = key.toLowerCase();
        String namespacedKey = (plugin.getName() + "." + key).toLowerCase();
        if (!this.has(baseKey)) {
            this.conditions.put(baseKey, entry);
        }
        this.conditions.put(namespacedKey, entry);
    }

    @Override
    public boolean has(String key) {
        return this.conditions.containsKey(key.toLowerCase());
    }

    @Override
    public ConditionFactory get(String key) {
        return this.getFull(key).entry();
    }

    @Override
    public RegistryEntry<ConditionFactory> getFull(String key) {
        return this.conditions.get(key.toLowerCase());
    }

    @Override
    public Map<String, RegistryEntry<ConditionFactory>> getAll() {
        return Collections.unmodifiableMap(this.conditions);
    }
}

