/*
 * Decompiled with CFR 0.152.
 */
package com.beepsterr.betterkeepinventory.Library.Versions;

import java.io.IOException;
import java.util.Objects;
import java.util.Properties;

public class Version
implements Comparable<Version> {
    public final int major;
    public final int minor;
    public final int patch;
    public final String flavor;
    public final int build;

    public Version(String versionStr) {
        String[] mainParts = versionStr.split("-");
        String[] versionNumbers = mainParts[0].split("\\.");
        if (versionNumbers.length != 3) {
            throw new IllegalArgumentException("Invalid version format: " + versionStr);
        }
        this.major = Integer.parseInt(versionNumbers[0]);
        this.minor = Integer.parseInt(versionNumbers[1]);
        this.patch = Integer.parseInt(versionNumbers[2]);
        this.flavor = mainParts.length >= 2 ? mainParts[1].toUpperCase() : "STABLE";
        this.build = mainParts.length >= 3 ? Integer.parseInt(mainParts[2]) : 0;
    }

    public static String getCommitHash() {
        Properties properties = new Properties();
        try {
            properties.load(Version.class.getClassLoader().getResourceAsStream("application.properties"));
            return properties.getProperty("git.commit.id.abbrev");
        }
        catch (IOException e) {
            e.printStackTrace();
            return "unknown";
        }
    }

    @Override
    public int compareTo(Version other) {
        if (this.major != other.major) {
            return Integer.compare(this.major, other.major);
        }
        if (this.minor != other.minor) {
            return Integer.compare(this.minor, other.minor);
        }
        if (this.patch != other.patch) {
            return Integer.compare(this.patch, other.patch);
        }
        if (!this.flavor.equals(other.flavor)) {
            if (this.flavor.equals("STABLE")) {
                return 1;
            }
            if (other.flavor.equals("STABLE")) {
                return -1;
            }
            return this.flavor.compareTo(other.flavor);
        }
        return Integer.compare(this.build, other.build);
    }

    public String toString() {
        String base = this.major + "." + this.minor + "." + this.patch;
        if (!this.flavor.equals("STABLE") || this.build > 0) {
            base = base + "-" + this.flavor;
        }
        if (this.build > 0) {
            base = base + "-" + this.build;
        }
        return base;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Version)) {
            return false;
        }
        Version v = (Version)o;
        return this.compareTo(v) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch, this.build);
    }
}

