/*
 * Decompiled with CFR 0.152.
 */
package com.beepsterr.betterkeepinventory.Library;

import com.beepsterr.betterkeepinventory.BetterKeepInventory;
import com.beepsterr.betterkeepinventory.Depends.PlaceholderAPI;
import com.beepsterr.betterkeepinventory.Library.Types.PlaceholderConditionType;
import com.beepsterr.betterkeepinventory.api.Exceptions.ConditionParseError;
import java.util.Objects;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class PlaceholderItem {
    private String placeholder;
    private final PlaceholderConditionType operator;
    private final String value;

    public PlaceholderItem(ConfigurationSection config) throws ConditionParseError {
        if (config.getString("placeholder") == null) {
            throw new ConditionParseError(config.getCurrentPath() + ".placeholder", "Placeholder is required");
        }
        if (config.getString("operator") == null) {
            throw new ConditionParseError(config.getCurrentPath() + ".operator", "Placeholder operator is required");
        }
        try {
            String value;
            switch (value = Objects.requireNonNull(config.getString("operator")).toUpperCase()) {
                case "EQUALS": 
                case "==": 
                case "=": {
                    this.operator = PlaceholderConditionType.EQUALS;
                    break;
                }
                case "!=": 
                case "<>": 
                case "NOT": {
                    this.operator = PlaceholderConditionType.NOT_EQUALS;
                    break;
                }
                case "INCLUDES": {
                    this.operator = PlaceholderConditionType.CONTAINS;
                    break;
                }
                case "*.": 
                case "BEGINS_WITH": {
                    this.operator = PlaceholderConditionType.STARTS_WITH;
                    break;
                }
                case ".*": 
                case "STOPS_WITH": {
                    this.operator = PlaceholderConditionType.ENDS_WITH;
                    break;
                }
                case ">": {
                    this.operator = PlaceholderConditionType.GREATER_THAN;
                    break;
                }
                case ">=": {
                    this.operator = PlaceholderConditionType.GREATER_THAN_OR_EQUALS;
                    break;
                }
                case "<": {
                    this.operator = PlaceholderConditionType.LESS_THAN;
                    break;
                }
                case "<=": {
                    this.operator = PlaceholderConditionType.LESS_THAN_OR_EQUALS;
                    break;
                }
                default: {
                    this.operator = PlaceholderConditionType.valueOf(value);
                    break;
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new ConditionParseError(config.getCurrentPath() + ".operator", "Placeholder operator must be one of " + Objects.toString(PlaceholderConditionType.values()));
        }
        if (config.getString("value") == null) {
            throw new ConditionParseError(config.getCurrentPath() + ".value", "Placeholder Value is required");
        }
        this.placeholder = config.getString("placeholder");
        if (!this.placeholder.startsWith("%") && !this.placeholder.endsWith("%")) {
            this.placeholder = "%" + this.placeholder + "%";
        }
        this.value = config.getString("value");
    }

    public boolean test(Player player) {
        BetterKeepInventory.instance.debug(player, "Testing Placeholder Condition: " + this.placeholder + " " + String.valueOf((Object)this.operator) + " " + this.value);
        if (!BetterKeepInventory.getInstance().checkDependency("PlaceholderAPI")) {
            return false;
        }
        String resolvedPlaceholder = PlaceholderAPI.setPlaceholders(player, this.placeholder);
        BetterKeepInventory plugin = BetterKeepInventory.getInstance();
        plugin.debug(player, "Going to test placeholder " + resolvedPlaceholder + " against " + this.value + " with operator " + String.valueOf((Object)this.operator));
        switch (this.operator) {
            case EQUALS: {
                return resolvedPlaceholder.equals(this.value);
            }
            case NOT_EQUALS: {
                return !resolvedPlaceholder.equals(this.value);
            }
            case CONTAINS: {
                return resolvedPlaceholder.contains(this.value);
            }
            case STARTS_WITH: {
                return resolvedPlaceholder.startsWith(this.value);
            }
            case ENDS_WITH: {
                return resolvedPlaceholder.endsWith(this.value);
            }
            case GREATER_THAN: {
                return Float.parseFloat(resolvedPlaceholder) > Float.parseFloat(this.value);
            }
            case LESS_THAN: {
                return Float.parseFloat(resolvedPlaceholder) < Float.parseFloat(this.value);
            }
            case GREATER_THAN_OR_EQUALS: {
                return Float.parseFloat(resolvedPlaceholder) >= Float.parseFloat(this.value);
            }
            case LESS_THAN_OR_EQUALS: {
                return Float.parseFloat(resolvedPlaceholder) <= Float.parseFloat(this.value);
            }
        }
        return false;
    }

    public String toString() {
        return "PlaceholderItem{placeholder='" + this.placeholder + "', operator=" + String.valueOf((Object)this.operator) + ", value='" + this.value + "'}";
    }
}

