/*
 * Decompiled with CFR 0.152.
 */
package com.beepsterr.betterkeepinventory.Library;

import com.beepsterr.betterkeepinventory.BetterKeepInventory;
import com.beepsterr.betterkeepinventory.api.BetterKeepInventoryAPI;
import com.beepsterr.betterkeepinventory.api.Condition;
import com.beepsterr.betterkeepinventory.api.Effect;
import com.beepsterr.betterkeepinventory.api.Exceptions.ConditionParseError;
import com.beepsterr.betterkeepinventory.api.Factory.ConditionFactory;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerRespawnEvent;

public class ConfigRule {
    private final String name;
    private final boolean enabled;
    private final ConfigRule parent;
    private List<Condition> conditions = new ArrayList<Condition>();
    private final List<Effect> effects = new ArrayList<Effect>();
    private final List<ConfigRule> children = new ArrayList<ConfigRule>();

    public ConfigRule(ConfigurationSection config, ConfigRule parent) {
        ConfigurationSection childrenSection;
        ConfigurationSection effectSection;
        this.parent = parent;
        this.name = config.getString("name", "Unnamed Rule");
        this.enabled = config.getBoolean("enabled", false);
        BetterKeepInventoryAPI api = (BetterKeepInventoryAPI)Bukkit.getServer().getServicesManager().load(BetterKeepInventoryAPI.class);
        if (api == null) {
            throw new RuntimeException("BetterKeepInventory API not loaded (?)");
        }
        if (config.isConfigurationSection("conditions")) {
            ConfigurationSection condSection = config.getConfigurationSection("conditions");
            assert (condSection != null);
            for (String key : condSection.getKeys(false)) {
                BetterKeepInventory.getInstance().debug("Trying Condition '" + key + "'");
                if (!api.conditionRegistry().has(key)) {
                    BetterKeepInventory.getInstance().debug("Condition '" + key + "' is not registered. Triggered in rule '" + this.name + ". Skipping.'");
                    continue;
                }
                ConfigurationSection section = condSection.getConfigurationSection(key);
                if (section == null) {
                    BetterKeepInventory.getInstance().debug("Condition '" + key + "' is missing configuration section in rule '" + this.name + "'. Skipping.");
                    continue;
                }
                try {
                    Condition cond = ((ConditionFactory)api.conditionRegistry().get(key)).create(section);
                    this.conditions.add(cond);
                }
                catch (ConditionParseError e) {
                    BetterKeepInventory.getInstance().getLogger().warning("Condition '" + key + "' could not be parsed");
                    BetterKeepInventory.getInstance().getLogger().warning("Error: " + e.getMessage());
                }
            }
        }
        if ((effectSection = config.getConfigurationSection("effects")) != null) {
            for (String key : effectSection.getKeys(false)) {
                ConfigurationSection effConfig = effectSection.getConfigurationSection(key);
                if (effConfig == null) continue;
                Effect effect = api.effectRegistry().create(key, effConfig);
                if (effect == null) {
                    BetterKeepInventory.getInstance().getLogger().warning("Effect '" + key + "' is not registered. Triggered in rule '" + this.name + "'!!!");
                    continue;
                }
                this.effects.add(effect);
            }
        }
        if ((childrenSection = config.getConfigurationSection("children")) != null) {
            for (String childKey : childrenSection.getKeys(false)) {
                ConfigurationSection childConfig = childrenSection.getConfigurationSection(childKey);
                if (childConfig == null) continue;
                this.children.add(new ConfigRule(childConfig, this));
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void trigger(Player ply, PlayerDeathEvent deathEvent, PlayerRespawnEvent respawnEvent) {
        BetterKeepInventory plugin = BetterKeepInventory.getInstance();
        if (!this.enabled) {
            plugin.debug(ply, "Rule " + String.valueOf(this) + " was skipped (not enabled)");
            return;
        }
        plugin.debug(ply, "Rule " + String.valueOf(this) + " checking conditions: " + String.valueOf(this.conditions.stream().map(Object::getClass)));
        if (this.conditions.isEmpty() || this.conditions.stream().allMatch(c -> c.check(ply, deathEvent, respawnEvent))) {
            plugin.debug(ply, "Rule " + String.valueOf(this) + " met conditions, running effects!");
            if (deathEvent != null) {
                for (Effect effect : this.effects) {
                    plugin.debug(ply, "Running effect (D): " + effect.toString());
                    effect.onDeath(ply, deathEvent);
                }
            }
            if (respawnEvent != null) {
                for (Effect effect : this.effects) {
                    plugin.debug(ply, "Running effect (R): " + effect.toString());
                    effect.onRespawn(ply, respawnEvent);
                }
            }
            for (ConfigRule child : this.children) {
                child.trigger(ply, deathEvent, respawnEvent);
            }
        } else {
            plugin.debug(ply, "Rule " + String.valueOf(this) + " was skipped (conditions not met)");
        }
    }

    public String toString() {
        return this.parent != null ? "ConfigRule{" + this.parent.getName() + " > " + this.name + "}" : "ConfigRule{" + this.name + "}";
    }
}

