/*
 * Decompiled with CFR 0.152.
 */
package com.beepsterr.betterkeepinventory.Library;

import com.beepsterr.betterkeepinventory.BetterKeepInventory;
import com.beepsterr.betterkeepinventory.Exceptions.UnloadableConfiguration;
import com.beepsterr.betterkeepinventory.Library.ConfigRule;
import com.beepsterr.betterkeepinventory.Library.Versions.Version;
import com.beepsterr.betterkeepinventory.Library.Versions.VersionChannel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class Config {
    private static Config instance;
    private FileConfiguration rawConfig;
    private FileConfiguration rawMessages;
    private final String version;
    private final VersionChannel notifyChannel;
    private final String hash;
    private final boolean debug;
    private final DefaultBehavior defaultBehavior;

    public Config(FileConfiguration config) throws UnloadableConfiguration {
        BetterKeepInventory plugin = BetterKeepInventory.getInstance();
        instance = this;
        this.rawConfig = config;
        if (Objects.equals(this.rawConfig.getString("version", "default"), "default")) {
            plugin.log("Creating default config.yml file");
            plugin.saveDefaultConfig();
            plugin.reloadConfig();
            this.rawConfig = plugin.getConfig();
        }
        plugin.saveResource("messages.yml", false);
        this.rawMessages = YamlConfiguration.loadConfiguration((File)new File(plugin.getDataFolder(), "messages.yml"));
        plugin.log("Loading configuration from " + config.getCurrentPath());
        this.version = config.getString("version", "2.0.0");
        this.notifyChannel = VersionChannel.valueOf(config.getString("notify_channel", "STABLE").toUpperCase());
        this.hash = config.getString("hash", "OLD");
        this.debug = config.getBoolean("debug", false);
        try {
            this.LoadMessages(plugin);
        }
        catch (IOException e) {
            throw new UnloadableConfiguration(e.getMessage());
        }
        this.MigrateConfiguration();
        this.defaultBehavior = DefaultBehavior.valueOf(config.getString("default_behavior", "INHERIT").toUpperCase());
    }

    public static Config getInstance() {
        return instance;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public DefaultBehavior getDefaultBehavior() {
        return this.defaultBehavior;
    }

    public List<ConfigRule> getRules() {
        ArrayList<ConfigRule> rules = new ArrayList<ConfigRule>();
        ConfigurationSection rulesSection = this.rawConfig.getConfigurationSection("rules");
        if (rulesSection != null) {
            for (String ruleKey : rulesSection.getKeys(false)) {
                ConfigurationSection ruleSection = rulesSection.getConfigurationSection(ruleKey);
                if (ruleSection == null) continue;
                rules.add(new ConfigRule(ruleSection, null));
            }
        }
        return rules;
    }

    public VersionChannel getNotifyChannel() {
        return this.notifyChannel;
    }

    public String getMessage(String key, Map<String, String> replacements) {
        if (this.rawMessages == null) {
            BetterKeepInventory.getInstance().log("Messages not loaded?? Check if messages.yml exists.");
            return key;
        }
        if (!this.rawMessages.contains(key)) {
            BetterKeepInventory.getInstance().log("Did not find message with key: " + key);
            return key;
        }
        String message = this.rawMessages.getString(key, key);
        if (replacements != null) {
            for (Map.Entry<String, String> entry : replacements.entrySet()) {
                message = message.replace("{" + entry.getKey() + "}", entry.getValue());
            }
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public void sendMessage(Player ply, String key, Map<String, String> replacements) {
        String message = this.getMessage(key, replacements);
        if (!message.isEmpty()) {
            ply.sendMessage(message);
        }
    }

    public void LoadMessages(BetterKeepInventory plugin) throws IOException {
        File file = new File(plugin.getDataFolder(), "messages.yml");
        YamlConfiguration userConfig = YamlConfiguration.loadConfiguration((File)file);
        InputStream defConfigStream = plugin.getResource("messages.yml");
        YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream, StandardCharsets.UTF_8));
        for (String key : defaultConfig.getKeys(true)) {
            if (userConfig.contains(key)) continue;
            userConfig.set(key, defaultConfig.get(key));
        }
        userConfig.save(file);
        this.rawMessages = userConfig;
    }

    public void MigrateConfiguration() throws UnloadableConfiguration {
        BetterKeepInventory plugin = BetterKeepInventory.getInstance();
        int legacyConfigVersion = this.rawConfig.getInt("main.config_version", 0);
        if (legacyConfigVersion > 0) {
            throw new UnloadableConfiguration("Detected a legacy configuration file, refusing to load it.\nPlease read the migration instructions at:\nhttps://beeps.notion.site/Migrating-to-2-0-244f258220598076bbbacc7af661f068");
        }
        String installedVersion = plugin.version.major + "." + plugin.version.minor + "." + plugin.version.patch;
        if (!installedVersion.equals(this.version)) {
            // empty if block
        }
        this.rawConfig.set("version", (Object)installedVersion);
        this.rawConfig.set("hash", (Object)Version.getCommitHash());
        BetterKeepInventory.getInstance().saveConfig();
    }

    public static enum DefaultBehavior {
        INHERIT,
        DROP,
        KEEP;

    }
}

