/*
 * Decompiled with CFR 0.152.
 */
package com.beepsterr.betterkeepinventory.Events;

import com.beepsterr.betterkeepinventory.BetterKeepInventory;
import com.beepsterr.betterkeepinventory.Library.ConfigRule;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;

public class OnPlayerDeath
implements Listener {
    BetterKeepInventory plugin;

    public OnPlayerDeath(BetterKeepInventory main) {
        this.plugin = main;
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player ply = event.getEntity();
        switch (this.plugin.config.getDefaultBehavior()) {
            case KEEP: {
                event.getDrops().clear();
                event.setDroppedExp(0);
                event.setKeepLevel(true);
                event.setKeepInventory(true);
                break;
            }
            case DROP: {
                event.setKeepLevel(false);
                event.setKeepInventory(false);
            }
        }
        ++BetterKeepInventory.instance.metrics.deathsProcessed;
        for (ConfigRule rule : this.plugin.config.getRules()) {
            rule.trigger(ply, event, null);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        for (ConfigRule rule : this.plugin.config.getRules()) {
            rule.trigger(event.getPlayer(), null, event);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player ply = event.getPlayer();
        if (ply.hasPermission("betterkeepinventory.version.notify")) {
            BetterKeepInventory.getScheduler().getScheduler().runAsync(consumer -> {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (this.plugin.versionChecker != null && this.plugin.versionChecker.IsUpdateAvailable()) {
                    ply.sendMessage(String.valueOf(ChatColor.YELLOW) + "A new version of BetterKeepInventory is available!");
                    ply.sendMessage(String.valueOf(ChatColor.GREEN) + this.plugin.versionChecker.foundVersion.toString() + String.valueOf(ChatColor.YELLOW) + " (Installed: " + this.plugin.version.toString() + ")");
                }
            });
        }
    }
}

