/*
 * Decompiled with CFR 0.152.
 */
package com.beepsterr.betterkeepinventory.Content.Effects.Vault;

import com.beepsterr.betterkeepinventory.BetterKeepInventory;
import com.beepsterr.betterkeepinventory.Depends.Vault;
import com.beepsterr.betterkeepinventory.api.Effect;
import java.util.HashMap;
import java.util.Random;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerRespawnEvent;

public class VaultEffect
implements Effect {
    private final Mode mode;
    private final double min;
    private final double max;
    private final boolean allowNegativeBalance;

    public VaultEffect(ConfigurationSection config) {
        this.mode = Mode.valueOf(config.getString("mode", "PERCENTAGE").toUpperCase());
        this.min = config.getDouble("min", 0.0);
        this.max = config.getDouble("max", 0.0);
        this.allowNegativeBalance = config.getBoolean("allow_negative_balance", false);
    }

    @Override
    public void onRespawn(Player ply, PlayerRespawnEvent event) {
    }

    @Override
    public void onDeath(Player ply, PlayerDeathEvent event) {
        double balanceLoss;
        Vault vault = new Vault(BetterKeepInventory.getInstance());
        BetterKeepInventory plugin = BetterKeepInventory.getInstance();
        Random rng = plugin.rng;
        double playerBalance = vault.getPlayerBalance(ply);
        if (playerBalance < (balanceLoss = this.calculateLoss(playerBalance, rng)) && !this.allowNegativeBalance) {
            balanceLoss = playerBalance;
        }
        vault.takeMoney(ply, balanceLoss);
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("amount", vault.format(balanceLoss));
        plugin.config.sendMessage(ply, "effects.economy", replacements);
        plugin.debug(ply, "EconomyLoss: Took " + balanceLoss + " from player " + ply.getName());
    }

    private double calculateLoss(double balance, Random rng) {
        return switch (this.mode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.SIMPLE -> this.min + (this.max - this.min) * rng.nextDouble();
            case Mode.PERCENTAGE -> balance * ((this.min + (this.max - this.min) * rng.nextDouble()) / 100.0);
        };
    }

    public static enum Mode {
        SIMPLE,
        PERCENTAGE;

    }
}

