/*
 * Decompiled with CFR 0.152.
 */
package com.beepsterr.betterkeepinventory.Content.Effects;

import com.beepsterr.betterkeepinventory.BetterKeepInventory;
import com.beepsterr.betterkeepinventory.api.Effect;
import java.util.HashMap;
import java.util.Random;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerRespawnEvent;

public class ExpEffect
implements Effect {
    private final Mode mode;
    private final How how;
    private final float min;
    private final float max;

    public ExpEffect(ConfigurationSection config) {
        this.mode = Mode.valueOf(config.getString("mode", "PERCENTAGE").toUpperCase());
        this.how = How.valueOf(config.getString("how", "DROP").toUpperCase());
        this.min = (float)config.getDouble("min", 0.0);
        this.max = (float)config.getDouble("max", 0.0);
    }

    @Override
    public void onRespawn(Player ply, PlayerRespawnEvent event) {
    }

    @Override
    public void onDeath(Player ply, PlayerDeathEvent event) {
        BetterKeepInventory plugin = BetterKeepInventory.getInstance();
        Random rng = plugin.rng;
        int playerExpLevel = ply.getLevel();
        int levelsToLose = switch (this.mode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.SIMPLE -> (int)((double)this.min + (double)(this.max - this.min) * rng.nextDouble());
            case Mode.PERCENTAGE -> (int)((double)playerExpLevel * (((double)this.min + (double)(this.max - this.min) * rng.nextDouble()) / 100.0));
            case Mode.ALL -> playerExpLevel;
        };
        plugin.debug(ply, "is losing " + levelsToLose + " levels of experience.");
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("amount", String.valueOf(Math.min(levelsToLose, playerExpLevel)));
        if (levelsToLose < 1) {
            return;
        }
        switch (this.how) {
            case DELETE: {
                ply.setLevel(playerExpLevel - levelsToLose);
                ply.setExp(0.0f);
                plugin.config.sendMessage(ply, "effects.exp_loss", replacements);
                break;
            }
            case DROP: {
                float expToDrop;
                if (playerExpLevel <= levelsToLose) {
                    expToDrop = (float)this.getExpAtLevel(playerExpLevel) + ply.getExp();
                    ply.setLevel(0);
                    ply.setExp(0.0f);
                } else {
                    expToDrop = this.getExpAtLevel(playerExpLevel) - this.getExpAtLevel(playerExpLevel - levelsToLose);
                    ply.setLevel(playerExpLevel - levelsToLose);
                    ply.setExp(0.0f);
                }
                plugin.debug(ply, "dropping " + expToDrop + " experience points.");
                ExperienceOrb orb = (ExperienceOrb)ply.getWorld().spawn(ply.getLocation(), ExperienceOrb.class);
                orb.setExperience(Math.round(expToDrop));
                plugin.config.sendMessage(ply, "effects.exp_dropped", replacements);
            }
        }
    }

    private int getExpAtLevel(int level) {
        if (level <= 16) {
            return level * level + 6 * level;
        }
        if (level <= 31) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
    }

    public static enum Mode {
        SIMPLE,
        PERCENTAGE,
        ALL;

    }

    public static enum How {
        DELETE,
        DROP;

    }
}

