/*
 * Decompiled with CFR 0.152.
 */
package com.beepsterr.betterkeepinventory.Content.Effects;

import com.beepsterr.betterkeepinventory.BetterKeepInventory;
import com.beepsterr.betterkeepinventory.Library.Utilities;
import com.beepsterr.betterkeepinventory.api.Effect;
import com.beepsterr.betterkeepinventory.api.Types.MaterialType;
import com.beepsterr.betterkeepinventory.api.Types.SlotType;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class DropItemEffect
implements Effect {
    private final Mode mode;
    private final float min;
    private final float max;
    private List<String> nameFilters = List.of();
    private List<String> loreFilters = List.of();
    private SlotType slots = new SlotType(List.of());
    private MaterialType items = new MaterialType(List.of());

    public DropItemEffect(ConfigurationSection config) {
        this.mode = Mode.valueOf(config.getString("mode", "SIMPLE").toUpperCase());
        this.min = (float)config.getDouble("min", 0.0);
        this.max = (float)config.getDouble("max", 0.0);
        ConfigurationSection filters = config.getConfigurationSection("filters");
        if (filters != null) {
            this.slots = new SlotType(Utilities.ConfigList(filters, "slots"));
            this.items = new MaterialType(Utilities.ConfigList(filters, "items"));
            this.nameFilters = Utilities.ConfigList(filters, "name");
            this.loreFilters = Utilities.ConfigList(filters, "lore");
        }
    }

    @Override
    public void onRespawn(Player ply, PlayerRespawnEvent event) {
    }

    @Override
    public void onDeath(Player ply, PlayerDeathEvent event) {
        BetterKeepInventory plugin = BetterKeepInventory.getInstance();
        Random rng = plugin.rng;
        List<Integer> dropSlots = this.slots.getSlotIds();
        List<Material> dropItems = this.items.getMaterials();
        for (int i = 0; i < ply.getInventory().getSize(); ++i) {
            ItemStack item = ply.getInventory().getItem(i);
            if (item == null) continue;
            ItemMeta meta = item.getItemMeta();
            if (!(dropItems.isEmpty() || this.items.isIncludeAll() || dropItems.contains(item.getType()))) {
                plugin.debug(ply, "Drop skipped due to item filter: " + String.valueOf(item.getType()));
                continue;
            }
            if (!dropSlots.isEmpty() && !dropSlots.contains(i)) {
                plugin.debug(ply, "Drop skipped due to slot filter: " + String.valueOf(item.getType()) + " at slot " + i);
                continue;
            }
            if (meta != null) {
                if (!this.nameFilters.isEmpty() && !Utilities.advancedStringCompare(meta.getDisplayName(), this.nameFilters)) {
                    plugin.debug(ply, "Drop skipped due to name filter: " + String.valueOf(item.getType()) + " with name " + meta.getDisplayName());
                    continue;
                }
                if (meta.getLore() != null) {
                    boolean loreFilterMatched = false;
                    for (String lore : meta.getLore()) {
                        if (this.loreFilters.isEmpty() || Utilities.advancedStringCompare(lore, this.loreFilters)) continue;
                        plugin.debug(ply, "Drop skipped due to lore filter: " + String.valueOf(item.getType()) + " with lore " + lore);
                        loreFilterMatched = true;
                    }
                    if (loreFilterMatched) continue;
                }
            }
            if (this.mode == Mode.ALL) {
                ply.getWorld().dropItemNaturally(ply.getLocation(), item);
                ply.getInventory().setItem(i, null);
                continue;
            }
            int inventoryCount = item.getAmount();
            int removalCount = 0;
            switch (this.mode) {
                case SIMPLE: {
                    removalCount = (int)((double)this.min + (double)(this.max - this.min) * rng.nextDouble());
                    break;
                }
                case PERCENTAGE: {
                    double percentage = (double)this.min + (double)(this.max - this.min) * rng.nextDouble();
                    removalCount = (int)((double)inventoryCount * (percentage / 100.0));
                }
            }
            if (removalCount <= 0) continue;
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("amount", String.valueOf(removalCount));
            replacements.put("item", MaterialType.GetName(item));
            plugin.config.sendMessage(ply, "effects.drop", replacements);
            plugin.debug(ply, "DropItemEffect: Dropping " + removalCount + " items from slot " + i + " (" + String.valueOf(item.getType()) + ")");
            if (inventoryCount - removalCount < 0) {
                removalCount = inventoryCount;
            }
            if (removalCount == 0) continue;
            ItemStack itemClone = item.clone();
            itemClone.setAmount(removalCount);
            ply.getWorld().dropItemNaturally(ply.getLocation(), itemClone);
            if (inventoryCount - removalCount == 0) {
                ply.getInventory().setItem(i, null);
                continue;
            }
            item.setAmount(inventoryCount - removalCount);
            ply.getInventory().setItem(i, item);
        }
    }

    public static enum Mode {
        SIMPLE,
        PERCENTAGE,
        ALL;

    }
}

