/*
 * Decompiled with CFR 0.152.
 */
package com.beepsterr.betterkeepinventory.Content.Effects;

import com.beepsterr.betterkeepinventory.BetterKeepInventory;
import com.beepsterr.betterkeepinventory.Library.Utilities;
import com.beepsterr.betterkeepinventory.api.Effect;
import com.beepsterr.betterkeepinventory.api.Types.MaterialType;
import com.beepsterr.betterkeepinventory.api.Types.SlotType;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class DamageItemEffect
implements Effect {
    private final Mode mode;
    private final float min;
    private final float max;
    private final boolean useEnchantments;
    private final boolean dontBreak;
    private List<String> nameFilters = List.of();
    private List<String> loreFilters = List.of();
    private SlotType slots = new SlotType(List.of());
    private MaterialType items = new MaterialType(List.of());

    public DamageItemEffect(ConfigurationSection config) {
        this.mode = Mode.valueOf(config.getString("mode", "PERCENTAGE").toUpperCase());
        this.min = (float)config.getDouble("min", 0.0);
        this.max = (float)config.getDouble("max", 0.0);
        this.useEnchantments = config.getBoolean("use_enchantments", false);
        this.dontBreak = config.getBoolean("dont_break", false);
        ConfigurationSection filters = config.getConfigurationSection("filters");
        if (filters != null) {
            this.slots = new SlotType(Utilities.ConfigList(filters, "slots"));
            this.items = new MaterialType(Utilities.ConfigList(filters, "items"));
            this.nameFilters = Utilities.ConfigList(filters, "name");
            this.loreFilters = Utilities.ConfigList(filters, "lore");
        }
    }

    @Override
    public void onRespawn(Player player, PlayerRespawnEvent event) {
    }

    @Override
    public void onDeath(Player ply, PlayerDeathEvent event) {
        BetterKeepInventory plugin = BetterKeepInventory.getInstance();
        Random rng = plugin.rng;
        List<Integer> slots = this.slots.getSlotIds();
        List<Material> items = this.items.getMaterials();
        BetterKeepInventory.instance.debug(ply, "The Items Are " + String.valueOf(items));
        for (int i = 0; i < ply.getInventory().getSize(); ++i) {
            ItemStack item = ply.getInventory().getItem(i);
            if (item == null) continue;
            ItemMeta meta = item.getItemMeta();
            if (!(items.isEmpty() || this.items.isIncludeAll() || items.contains(item.getType()))) {
                plugin.debug(ply, "Damage skipped due to item filter: " + String.valueOf(item.getType()));
                continue;
            }
            if (!slots.isEmpty() && !slots.contains(i)) {
                plugin.debug(ply, "Damage skipped due to slot filter: " + String.valueOf(item.getType()) + " at slot " + i);
                continue;
            }
            if (meta != null) {
                if (!this.nameFilters.isEmpty() && !Utilities.advancedStringCompare(meta.getDisplayName(), this.nameFilters)) {
                    plugin.debug(ply, "Damage skipped due to name filter: " + String.valueOf(item.getType()) + " with name " + meta.getDisplayName());
                    continue;
                }
                if (meta.getLore() != null) {
                    boolean loreFilterMatched = false;
                    for (String lore : meta.getLore()) {
                        if (this.loreFilters.isEmpty() || Utilities.advancedStringCompare(lore, this.loreFilters)) continue;
                        loreFilterMatched = true;
                    }
                    if (loreFilterMatched) {
                        plugin.debug(ply, "Damage skipped due to lore filter: " + String.valueOf(item.getType()));
                        continue;
                    }
                }
            }
            if (!(meta instanceof Damageable)) {
                plugin.debug(ply, "Damage skipped due to item not being damageable: " + String.valueOf(item.getType()));
                continue;
            }
            Damageable damageableMeta = (Damageable)meta;
            int currentDamageTaken = damageableMeta.getDamage();
            short maxDurability = item.getType().getMaxDurability();
            int damageToTake = this.calculateDamage(rng, currentDamageTaken, maxDurability);
            if (damageToTake < 0) continue;
            damageToTake = this.applyUnbreaking(item, damageToTake);
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("amount", String.valueOf(damageToTake));
            replacements.put("item", MaterialType.GetName(item));
            plugin.metrics.durabilityPointsLost += damageToTake;
            if (maxDurability - currentDamageTaken - damageToTake < 0) {
                if (this.dontBreak || item.getType() == Material.ELYTRA) {
                    damageableMeta.setDamage((int)maxDurability);
                    item.setItemMeta((ItemMeta)damageableMeta);
                    plugin.debug(ply, "Item saved from breaking: " + String.valueOf(item.getType()));
                    plugin.config.sendMessage(ply, "effects.damage", replacements);
                    continue;
                }
                item.setAmount(item.getAmount() - 1);
                damageableMeta.setDamage(0);
                item.setItemMeta(meta);
                ply.getWorld().playSound(ply.getLocation(), Sound.ENTITY_ITEM_BREAK, 0.8f, 0.8f);
                plugin.debug(ply, "Item broke: " + String.valueOf(item.getType()));
                plugin.config.sendMessage(ply, "effects.damage_break", replacements);
                continue;
            }
            damageableMeta.setDamage(currentDamageTaken + damageToTake);
            item.setItemMeta(meta);
            plugin.config.sendMessage(ply, "effects.damage", replacements);
        }
    }

    private int calculateDamage(Random rng, int currentDamageTaken, int maxDurability) {
        return switch (this.mode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.SIMPLE -> (int)((double)this.min + (double)(this.max - this.min) * rng.nextDouble());
            case Mode.PERCENTAGE -> (int)((double)maxDurability * (((double)this.min + (double)(this.max - this.min) * rng.nextDouble()) / 100.0));
            case Mode.PERCENTAGE_REMAINING -> (int)((double)(maxDurability - currentDamageTaken) * (((double)this.min + (double)(this.max - this.min) * rng.nextDouble()) / 100.0));
        };
    }

    private int applyUnbreaking(ItemStack item, int damageToTake) {
        if (!this.useEnchantments) {
            return damageToTake;
        }
        if (!item.getEnchantments().containsKey(Enchantment.DURABILITY)) {
            return damageToTake;
        }
        int level = item.getEnchantmentLevel(Enchantment.DURABILITY);
        if (level > 9) {
            return 0;
        }
        return (int)((double)damageToTake * (1.0 - 0.33 * (double)level));
    }

    public static enum Mode {
        PERCENTAGE,
        PERCENTAGE_REMAINING,
        SIMPLE;

    }
}

