/*
 * Decompiled with CFR 0.152.
 */
package com.beepsterr.betterkeepinventory.Commands;

import com.beepsterr.betterkeepinventory.BetterKeepInventory;
import com.beepsterr.betterkeepinventory.Exceptions.UnloadableConfiguration;
import com.beepsterr.betterkeepinventory.Library.Config;
import com.beepsterr.betterkeepinventory.Library.Versions.VersionChannel;
import com.beepsterr.betterkeepinventory.Library.Versions.VersionChecker;
import com.beepsterr.betterkeepinventory.api.BetterKeepInventoryAPI;
import com.beepsterr.betterkeepinventory.api.RegistryEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;

public class MainCommand
implements CommandExecutor,
TabCompleter {
    private boolean checkPerm(CommandSender sender, String permission) {
        return sender.hasPermission(permission) || sender instanceof ConsoleCommandSender;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length > 0) {
            return switch (args[0]) {
                case "reload" -> this.OnReloadCommand(sender, command, label, args);
                case "registry" -> this.OnRegistryCommand(sender, command, label, args);
                default -> {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown command. Use /betterkeepinventory for help.");
                    yield true;
                }
            };
        }
        if (!this.checkPerm(sender, "betterkeepinventory.command.help")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
            return true;
        }
        BetterKeepInventory plugin = BetterKeepInventory.getInstance();
        String title = String.valueOf(ChatColor.BOLD) + String.valueOf(ChatColor.GREEN) + plugin.getDescription().getName();
        if (this.checkPerm(sender, "betterkeepinventory.version")) {
            title = title + " " + String.valueOf(ChatColor.GRAY) + "[" + String.valueOf(ChatColor.LIGHT_PURPLE) + "v" + plugin.version.toString() + String.valueOf(ChatColor.GRAY) + "]";
        }
        TextComponent helpTitleComponent = new TextComponent(title);
        sender.spigot().sendMessage((BaseComponent)helpTitleComponent);
        if (this.checkPerm(sender, "betterkeepinventory.version")) {
            if (plugin.versionChecker.channel != VersionChannel.NONE) {
                boolean isUpdateAvailable = plugin.versionChecker.IsUpdateAvailable();
                if (!isUpdateAvailable) {
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.ITALIC) + "No updates available.");
                } else {
                    String updateURL = switch (plugin.versionChecker.channel) {
                        case VersionChannel.SNAPSHOT -> "https://github.com/BeepSterr/BetterKeepInventory/actions/workflows/build_snapshot.yml";
                        default -> "https://www.spigotmc.org/resources/betterkeepinventory.93081/";
                    };
                    TextComponent updateAvailableComponent = new TextComponent(plugin.versionChecker.foundVersion.toString() + " is available for download!");
                    updateAvailableComponent.setColor(ChatColor.GOLD);
                    updateAvailableComponent.setItalic(Boolean.valueOf(true));
                    updateAvailableComponent.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, updateURL));
                    updateAvailableComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(String.valueOf(ChatColor.GOLD) + "Download Update").create()));
                    sender.spigot().sendMessage((BaseComponent)updateAvailableComponent);
                }
            }
            sender.sendMessage("");
            if ("BETA".equals(plugin.version.flavor)) {
                TextComponent betaWarning = new TextComponent("You are running a BETA version of BetterKeepInventory! If things don't work or you find bugs, please report them on Github or Discord!");
                betaWarning.setColor(ChatColor.RED);
                betaWarning.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://leafcat.live/discord"));
                betaWarning.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(String.valueOf(ChatColor.AQUA) + "Join Discord").create()));
                sender.spigot().sendMessage((BaseComponent)betaWarning);
                sender.sendMessage("");
            }
            if ("SNAPSHOT".equals(plugin.version.flavor)) {
                TextComponent betaWarning = new TextComponent("You are running a SNAPSHOT version of BetterKeepInventory! Expect things to not work and report any bugs you find on GitHub or Discord!");
                betaWarning.setColor(ChatColor.DARK_RED);
                betaWarning.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://leafcat.live/discord"));
                betaWarning.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(String.valueOf(ChatColor.AQUA) + "Join Discord").create()));
                sender.spigot().sendMessage((BaseComponent)betaWarning);
                sender.sendMessage("");
            }
        }
        this.SendLink(sender, "SpigotMC", "https://www.spigotmc.org/resources/betterkeepinventory.93081/");
        this.SendLink(sender, "Documentation", "https://beeps.notion.site/Better-Keep-Inventory-f5d49a15a8174ce598bbb876d3003e46");
        this.SendLink(sender, "Discord", "https://leafcat.live/discord");
        sender.sendMessage("");
        if (this.checkPerm(sender, "betterkeepinventory.command.reload")) {
            TextComponent reloadCommand = new TextComponent("/betterki reload");
            reloadCommand.setColor(ChatColor.AQUA);
            reloadCommand.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/betterkeepinventory reload"));
            sender.spigot().sendMessage((BaseComponent)reloadCommand);
        }
        if (this.checkPerm(sender, "betterkeepinventory.command.registry")) {
            TextComponent registryEffectsCommand = new TextComponent("/betterki registry effects");
            registryEffectsCommand.setColor(ChatColor.AQUA);
            registryEffectsCommand.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/betterkeepinventory registry effects"));
            sender.spigot().sendMessage((BaseComponent)registryEffectsCommand);
            TextComponent registryConditionsCommand = new TextComponent("/betterki registry conditions");
            registryConditionsCommand.setColor(ChatColor.AQUA);
            registryConditionsCommand.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/betterkeepinventory registry conditions"));
            sender.spigot().sendMessage((BaseComponent)registryConditionsCommand);
        }
        return true;
    }

    public void SendLink(CommandSender sender, String name, String link) {
        if (sender instanceof ConsoleCommandSender) {
            sender.sendMessage("\ud83c\udf0e " + name + String.valueOf(ChatColor.DARK_GRAY) + " ( " + link + " )");
        } else {
            TextComponent linkComponent = new TextComponent("\ud83c\udf0e " + name);
            linkComponent.setColor(ChatColor.YELLOW);
            linkComponent.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, link));
            sender.spigot().sendMessage((BaseComponent)linkComponent);
        }
    }

    public boolean OnRegistryCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!this.checkPerm(sender, "betterkeepinventory.command.registry")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
            return true;
        }
        BetterKeepInventoryAPI api = (BetterKeepInventoryAPI)Bukkit.getServer().getServicesManager().load(BetterKeepInventoryAPI.class);
        if (api == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "BetterKeepInventory API is not available.");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /betterkeepinventory registry <type>");
            return true;
        }
        switch (args[1].toLowerCase()) {
            case "effects": {
                MainCommand.printRegistryEntries(sender, "Registered Effects", api.effectRegistry().getAll());
                break;
            }
            case "conditions": {
                MainCommand.printRegistryEntries(sender, "Registered Conditions", api.conditionRegistry().getAll());
                break;
            }
            default: {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown registry type: " + args[1]);
                return true;
            }
        }
        return true;
    }

    public static <T> void printRegistryEntries(CommandSender sender, String title, Map<String, RegistryEntry<T>> allEntries) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + title + " (" + allEntries.size() + "):");
        HashSet<String> printedShorts = new HashSet<String>();
        for (Map.Entry<String, RegistryEntry<T>> entry : allEntries.entrySet()) {
            RegistryEntry<T> regEntry;
            Plugin plugin;
            String pluginPrefix;
            String fullKey = entry.getKey();
            if (!fullKey.startsWith(pluginPrefix = (plugin = (regEntry = entry.getValue()).plugin()).getName().toLowerCase() + ".")) continue;
            String shortKey = fullKey.substring(pluginPrefix.length());
            boolean showShort = allEntries.containsKey(shortKey) && allEntries.get(shortKey).plugin().equals(plugin) && printedShorts.add(shortKey);
            String display = String.valueOf(ChatColor.GREEN) + fullKey;
            if (showShort) {
                display = display + String.valueOf(ChatColor.LIGHT_PURPLE) + " (" + shortKey + ")";
            }
            sender.sendMessage(display);
            TextComponent pluginComponent = new TextComponent(plugin.getDescription().getFullName());
            pluginComponent.setColor(ChatColor.GREEN);
            pluginComponent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/version " + plugin.getName()));
            pluginComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("/version " + plugin.getName()).create()));
            TextComponent label = new TextComponent("provided by: ");
            label.setColor(ChatColor.GRAY);
            label.addExtra((BaseComponent)pluginComponent);
            sender.spigot().sendMessage((BaseComponent)label);
            sender.sendMessage("");
        }
    }

    public boolean OnReloadCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!this.checkPerm(sender, "betterkeepinventory.command.reload")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
            return true;
        }
        BetterKeepInventory plugin = BetterKeepInventory.getInstance();
        plugin.reloadConfig();
        try {
            plugin.config = new Config(plugin.getConfig());
        }
        catch (UnloadableConfiguration e) {
            String alert = "\n" + String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + " RELOAD ERROR!!\n" + String.valueOf(ChatColor.RED) + "BetterKeepInventory encountered a problem while reloading:\n\n" + String.valueOf(ChatColor.YELLOW) + e.getMessage() + "\n\n" + String.valueOf(ChatColor.RED) + "The updated configuration was NOT loaded.\n" + String.valueOf(ChatColor.RED) + "You should fix the issue, and try again\n";
            sender.sendMessage(alert);
            plugin.getLogger().severe(alert);
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Configuration reloaded successfully.");
        if (plugin.versionChecker != null) {
            plugin.versionChecker.CancelCheck();
        }
        plugin.versionChecker = new VersionChecker(plugin.config.getNotifyChannel());
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("betterkeepinventory.command.help")) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            ArrayList<String> options = new ArrayList<String>();
            if (sender.hasPermission("betterkeepinventory.command.reload")) {
                options.add("reload");
            }
            if (sender.hasPermission("betterkeepinventory.command.registry")) {
                options.add("registry");
            }
            return options.stream().filter(opt -> opt.startsWith(args[0].toLowerCase())).toList();
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("registry")) {
            if (!sender.hasPermission("betterkeepinventory.command.registry")) {
                return Collections.emptyList();
            }
            return List.of("effects", "conditions").stream().filter(opt -> opt.startsWith(args[1].toLowerCase())).toList();
        }
        return Collections.emptyList();
    }
}

