/*
 * Decompiled with CFR 0.152.
 */
package com.beepsterr.betterkeepinventory;

import com.beepsterr.betterkeepinventory.Commands.MainCommand;
import com.beepsterr.betterkeepinventory.Content.Conditions.PermissionsCondition;
import com.beepsterr.betterkeepinventory.Content.Conditions.PlaceholderAPI.PlaceholderCondition;
import com.beepsterr.betterkeepinventory.Content.Conditions.Vault.VaultCondition;
import com.beepsterr.betterkeepinventory.Content.Conditions.WorldsCondition;
import com.beepsterr.betterkeepinventory.Content.Effects.DamageItemEffect;
import com.beepsterr.betterkeepinventory.Content.Effects.DropItemEffect;
import com.beepsterr.betterkeepinventory.Content.Effects.ExpEffect;
import com.beepsterr.betterkeepinventory.Content.Effects.HungerEffect;
import com.beepsterr.betterkeepinventory.Content.Effects.Vault.VaultEffect;
import com.beepsterr.betterkeepinventory.Depends.BetterKeepInventoryPlaceholderExpansion;
import com.beepsterr.betterkeepinventory.Events.OnPlayerDeath;
import com.beepsterr.betterkeepinventory.Exceptions.UnloadableConfiguration;
import com.beepsterr.betterkeepinventory.Library.Config;
import com.beepsterr.betterkeepinventory.Library.MetricContainer;
import com.beepsterr.betterkeepinventory.Library.Versions.Version;
import com.beepsterr.betterkeepinventory.Library.Versions.VersionChannel;
import com.beepsterr.betterkeepinventory.Library.Versions.VersionChecker;
import com.beepsterr.betterkeepinventory.Registries.PluginConditionRegistry;
import com.beepsterr.betterkeepinventory.Registries.PluginEffectRegistry;
import com.beepsterr.betterkeepinventory.api.BetterKeepInventoryAPI;
import com.beepsterr.betterkeepinventory.api.BetterKeepInventoryAPIImpl;
import com.beepsterr.lib.folialib.FoliaLib;
import java.util.Objects;
import java.util.Random;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public final class BetterKeepInventory
extends JavaPlugin
implements Listener {
    public Config config;
    public static BetterKeepInventory instance;
    private FoliaLib foliaLib;
    public Version version = new Version(this.getDescription().getVersion());
    public VersionChecker versionChecker;
    public Random rng = new Random();
    public MetricContainer metrics;
    private final PluginConditionRegistry conditionRegistry = new PluginConditionRegistry();
    private final PluginEffectRegistry effectRegistry = new PluginEffectRegistry();

    public void onEnable() {
        instance = this;
        this.foliaLib = new FoliaLib((Plugin)BetterKeepInventory.getInstance());
        BetterKeepInventoryAPIImpl api = new BetterKeepInventoryAPIImpl(this.conditionRegistry, this.effectRegistry);
        this.getServer().getServicesManager().register(BetterKeepInventoryAPI.class, (Object)api, (Plugin)this, ServicePriority.Highest);
        this.registerConditions(api);
        this.registerEffects(api);
        try {
            this.config = new Config(this.getConfig());
        }
        catch (UnloadableConfiguration e) {
            this.CrashAndDisable("Configuration failed to load!\n" + e.getMessage());
            return;
        }
        this.getServer().getPluginManager().registerEvents((Listener)new OnPlayerDeath(this), (Plugin)this);
        Objects.requireNonNull(this.getCommand("betterkeepinventory")).setExecutor((CommandExecutor)new MainCommand());
        Objects.requireNonNull(this.getCommand("betterkeepinventory")).setTabCompleter((TabCompleter)new MainCommand());
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.metrics = new MetricContainer();
        if (this.checkDependency("PlaceholderAPI")) {
            this.log("Hello PlaceholderAPI!");
            new BetterKeepInventoryPlaceholderExpansion().register();
        }
        if (this.config.getNotifyChannel() != VersionChannel.NONE) {
            this.versionChecker = new VersionChecker(this.config.getNotifyChannel());
        }
    }

    public void onDisable() {
        this.getServer().getServicesManager().unregister(BetterKeepInventoryAPI.class, (Object)this);
        if (this.versionChecker != null) {
            this.versionChecker.CancelCheck();
        }
    }

    private void registerEffects(BetterKeepInventoryAPI api) {
        api.effectRegistry().register((Plugin)this, "damage", DamageItemEffect::new);
        api.effectRegistry().register((Plugin)this, "drop", DropItemEffect::new);
        api.effectRegistry().register((Plugin)this, "exp", ExpEffect::new);
        api.effectRegistry().register((Plugin)this, "hunger", HungerEffect::new);
        if (this.checkDependency("Vault")) {
            api.effectRegistry().register((Plugin)this, "vault", VaultEffect::new);
        }
    }

    private void registerConditions(BetterKeepInventoryAPI api) {
        api.conditionRegistry().register((Plugin)this, "worlds", WorldsCondition::new);
        api.conditionRegistry().register((Plugin)this, "permissions", PermissionsCondition::new);
        if (this.checkDependency("Vault")) {
            api.conditionRegistry().register((Plugin)this, "vault", VaultCondition::new);
        }
        if (this.checkDependency("PlaceholderAPI")) {
            api.conditionRegistry().register((Plugin)this, "placeholders", PlaceholderCondition::new);
        }
    }

    public static BetterKeepInventory getInstance() {
        return instance;
    }

    public boolean checkDependency(String dep) {
        return Bukkit.getServer().getPluginManager().getPlugin(dep) != null;
    }

    public void CrashAndDisable(String message) {
        String alert = "\n" + String.valueOf(ChatColor.DARK_RED) + "=====================[ CRITICAL ERROR ]=====================\n" + String.valueOf(ChatColor.RED) + "BetterKeepInventory encountered a irrecoverable error:\n\n" + String.valueOf(ChatColor.YELLOW) + message + "\n\n" + String.valueOf(ChatColor.RED) + "The plugin has been disabled, and deaths will be handled by vanilla (!!)\n" + String.valueOf(ChatColor.RED) + "You should fix the issue, and restart the server to re-enable the plugin\n" + String.valueOf(ChatColor.DARK_RED) + "============================================================\n";
        this.getServer().getPluginManager().disablePlugin((Plugin)this);
        this.getLogger().log(Level.SEVERE, alert);
        this.getServer().getConsoleSender().sendMessage(alert);
        this.getLogger().log(Level.INFO, "Continuing with server start in 10 seconds...");
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getServer().getPluginManager().disablePlugin((Plugin)this);
    }

    public void debug(Player player, String message) {
        if (this.config.isDebug()) {
            this.log("[DEBUG] (" + player.getName() + ") " + message);
        }
    }

    public void debug(String message) {
        if (this.config.isDebug()) {
            this.getLogger().log(Level.INFO, "[DEBUG] " + message);
        }
    }

    public void log(String message) {
        this.getLogger().log(Level.INFO, message);
    }

    public static FoliaLib getScheduler() {
        return BetterKeepInventory.instance.foliaLib;
    }
}

