/*
 * Decompiled with CFR 0.152.
 */
package com.beanfeed.treechopper.listeners;

import com.beanfeed.treechopper.TreeChopper;
import com.beanfeed.treechopper.files.PlacedBlocks;
import com.google.common.collect.ImmutableList;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class BlockBreakEvent
implements Listener {
    private final ImmutableList<Material> AXES = ImmutableList.of((Object)Material.DIAMOND_AXE, (Object)Material.GOLDEN_AXE, (Object)Material.IRON_AXE, (Object)Material.STONE_AXE, (Object)Material.NETHERITE_AXE, (Object)Material.WOODEN_AXE, (Object)Material.COPPER_AXE);
    private final ImmutableList<Material> PICKAXES = ImmutableList.of((Object)Material.DIAMOND_PICKAXE, (Object)Material.GOLDEN_PICKAXE, (Object)Material.IRON_PICKAXE, (Object)Material.STONE_PICKAXE, (Object)Material.NETHERITE_PICKAXE, (Object)Material.WOODEN_PICKAXE, (Object)Material.COPPER_PICKAXE);

    @EventHandler
    public void onBlockBreakEvent(org.bukkit.event.block.BlockBreakEvent e) {
        Player p = e.getPlayer();
        ItemStack itemInHand = p.getInventory().getItemInMainHand();
        Block b = e.getBlock();
        int blockX = b.getLocation().getBlockX();
        int blockY = b.getLocation().getBlockY();
        int blockZ = b.getLocation().getBlockZ();
        String path = blockX + "," + blockY + "," + blockZ;
        boolean isPlayerPlacedBlock = PlacedBlocks.get().isInt(path);
        if ((this.AXES.contains((Object)itemInHand.getType()) && TreeChopper.LOGS.contains((Object)b.getType()) || this.PICKAXES.contains((Object)itemInHand.getType()) && TreeChopper.ORES.contains((Object)b.getType())) && !isPlayerPlacedBlock && p.isSneaking()) {
            this.checkNearbyBlocks(b, p, e);
        } else if (isPlayerPlacedBlock && TreeChopper.LOGS.contains((Object)b.getType())) {
            PlacedBlocks.get().set(path, null);
        }
    }

    public void checkNearbyBlocks(Block block, Player player, org.bukkit.event.block.BlockBreakEvent event) {
        int x = -1;
        int y = -1;
        int z = -1;
        Random rand = new Random();
        block7: for (int k = 0; k < 3; ++k) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    Location center = block.getLocation().clone();
                    center.add((double)x, (double)y, (double)z);
                    Block nearbyBlock = center.getBlock();
                    if (TreeChopper.LOGS.contains((Object)nearbyBlock.getType()) || TreeChopper.ORES.contains((Object)nearbyBlock.getType())) {
                        ItemStack tool = player.getInventory().getItemInMainHand();
                        nearbyBlock.breakNaturally(tool, true);
                        switch (nearbyBlock.getType()) {
                            case COAL_ORE: {
                                event.setExpToDrop(rand.nextInt(0, 2));
                                break;
                            }
                            case NETHER_GOLD_ORE: {
                                event.setExpToDrop(rand.nextInt(0, 1));
                                break;
                            }
                            case DIAMOND_ORE: 
                            case DEEPSLATE_DIAMOND_ORE: 
                            case EMERALD_ORE: 
                            case DEEPSLATE_EMERALD_ORE: {
                                event.setExpToDrop(rand.nextInt(3, 7));
                                break;
                            }
                            case LAPIS_ORE: 
                            case DEEPSLATE_LAPIS_ORE: 
                            case NETHER_QUARTZ_ORE: {
                                event.setExpToDrop(rand.nextInt(2, 5));
                                break;
                            }
                            case REDSTONE_ORE: 
                            case DEEPSLATE_REDSTONE_ORE: {
                                event.setExpToDrop(rand.nextInt(1, 5));
                            }
                        }
                        int xpAmount = event.getExpToDrop();
                        if (xpAmount > 0) {
                            ((ExperienceOrb)nearbyBlock.getWorld().spawn(nearbyBlock.getLocation(), ExperienceOrb.class)).setExperience(xpAmount);
                        }
                        short toolDurability = tool.getType().getMaxDurability();
                        ItemMeta meta = tool.getItemMeta();
                        Damageable dmg = (Damageable)meta;
                        if (dmg == null || dmg.getDamage() > toolDurability) {
                            player.getInventory().setItemInMainHand(null);
                            player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
                            break block7;
                        }
                        if (meta.hasEnchant(Enchantment.UNBREAKING)) {
                            int unbLevel = meta.getEnchantLevel(Enchantment.UNBREAKING);
                            double chanceOfDmg = 1.0 / (double)(unbLevel + 1);
                            if (rand.nextDouble() < chanceOfDmg) {
                                dmg.setDamage(dmg.getDamage() + 1);
                            }
                        } else {
                            dmg.setDamage(dmg.getDamage() + 1);
                        }
                        tool.setItemMeta((ItemMeta)dmg);
                        player.getInventory().setItemInMainHand(tool);
                        this.checkNearbyBlocks(nearbyBlock, player, event);
                    }
                    ++z;
                }
                ++x;
                z = -1;
            }
            ++y;
            x = -1;
            z = -1;
        }
    }
}

