/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.quark.logger.adapters;

import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bxteam.quark.logger.LogAdapter;
import org.bxteam.quark.logger.LogLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLogAdapter
implements LogAdapter {
    private final Logger logger;

    public JavaLogAdapter(@NotNull Logger logger) {
        this.logger = Objects.requireNonNull(logger, "logger");
    }

    @Override
    public void log(@NotNull LogLevel level, @NotNull String message) {
        this.logger.log(this.convertLevel(level), message);
    }

    @Override
    public void log(@NotNull LogLevel level, @NotNull String message, @Nullable Throwable throwable) {
        this.logger.log(this.convertLevel(level), message, throwable);
    }

    private Level convertLevel(LogLevel level) {
        return switch (level) {
            case LogLevel.DEBUG -> Level.FINE;
            case LogLevel.WARN -> Level.WARNING;
            case LogLevel.ERROR -> Level.SEVERE;
            default -> Level.INFO;
        };
    }
}

