/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.quark.classloader;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.Unsafe;

abstract class URLClassLoaderAccessor {
    protected final URLClassLoader classLoader;

    @NotNull
    public static URLClassLoaderAccessor create(@NotNull URLClassLoader classLoader) {
        Objects.requireNonNull(classLoader, "Class loader cannot be null");
        if (ReflectionURLClassLoaderAccessor.isSupported()) {
            return new ReflectionURLClassLoaderAccessor(classLoader);
        }
        if (UnsafeURLClassLoaderAccessor.isSupported()) {
            return new UnsafeURLClassLoaderAccessor(classLoader);
        }
        return new NoopURLClassLoaderAccessor(classLoader);
    }

    protected URLClassLoaderAccessor(@NotNull URLClassLoader classLoader) {
        this.classLoader = Objects.requireNonNull(classLoader, "Class loader cannot be null");
    }

    public abstract void addURL(@NotNull URL var1);

    public void addJarToClasspath(@NotNull Path jarPath) {
        Objects.requireNonNull(jarPath, "JAR path cannot be null");
        try {
            this.addURL(jarPath.toUri().toURL());
        }
        catch (MalformedURLException e) {
            throw new ClassLoaderAccessException("Invalid JAR path: " + String.valueOf(jarPath), e);
        }
    }

    @NotNull
    public String getType() {
        return this.getClass().getSimpleName();
    }

    protected static void throwAccessError(@Nullable Throwable cause) {
        String message = "Quark is unable to inject JARs into the URLClassLoader.\nYou may be able to fix this problem by adding the following JVM argument:\n--add-opens java.base/java.lang=ALL-UNNAMED\nAlternatively, try using a different class loader implementation.";
        throw new ClassLoaderAccessException(message, cause);
    }

    private static class ReflectionURLClassLoaderAccessor
    extends URLClassLoaderAccessor {
        private static final Method ADD_URL_METHOD = ReflectionURLClassLoaderAccessor.initializeAddUrlMethod();

        @Nullable
        private static Method initializeAddUrlMethod() {
            try {
                Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                return method;
            }
            catch (Exception e) {
                return null;
            }
        }

        static boolean isSupported() {
            return ADD_URL_METHOD != null;
        }

        ReflectionURLClassLoaderAccessor(@NotNull URLClassLoader classLoader) {
            super(classLoader);
        }

        @Override
        public void addURL(@NotNull URL url) {
            Objects.requireNonNull(url, "URL cannot be null");
            try {
                ADD_URL_METHOD.invoke((Object)this.classLoader, url);
            }
            catch (ReflectiveOperationException e) {
                ReflectionURLClassLoaderAccessor.throwAccessError(e);
            }
        }
    }

    private static class UnsafeURLClassLoaderAccessor
    extends URLClassLoaderAccessor {
        private static final Unsafe UNSAFE = UnsafeURLClassLoaderAccessor.initializeUnsafe();
        private final Collection<URL> unopenedURLs;
        private final Collection<URL> pathURLs;

        @Nullable
        private static Unsafe initializeUnsafe() {
            try {
                Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
                unsafeField.setAccessible(true);
                return (Unsafe)unsafeField.get(null);
            }
            catch (Exception e) {
                return null;
            }
        }

        static boolean isSupported() {
            return UNSAFE != null;
        }

        UnsafeURLClassLoaderAccessor(@NotNull URLClassLoader classLoader) {
            super(classLoader);
            Collection unopenedURLs = null;
            Collection pathURLs = null;
            try {
                Object urlClassPath = this.getFieldValue(URLClassLoader.class, classLoader, "ucp");
                unopenedURLs = (Collection)this.getFieldValue(urlClassPath.getClass(), urlClassPath, "unopenedUrls");
                pathURLs = (Collection)this.getFieldValue(urlClassPath.getClass(), urlClassPath, "path");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.unopenedURLs = unopenedURLs;
            this.pathURLs = pathURLs;
        }

        @Nullable
        private Object getFieldValue(@NotNull Class<?> clazz, @NotNull Object instance, @NotNull String fieldName) throws NoSuchFieldException {
            Field field = clazz.getDeclaredField(fieldName);
            long offset = UNSAFE.objectFieldOffset(field);
            return UNSAFE.getObject(instance, offset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addURL(@NotNull URL url) {
            Objects.requireNonNull(url, "URL cannot be null");
            if (this.unopenedURLs == null || this.pathURLs == null) {
                UnsafeURLClassLoaderAccessor.throwAccessError(new IllegalStateException("Unsafe accessor not properly initialized"));
            }
            Collection<URL> collection = this.unopenedURLs;
            synchronized (collection) {
                this.unopenedURLs.add(url);
                this.pathURLs.add(url);
            }
        }
    }

    private static class NoopURLClassLoaderAccessor
    extends URLClassLoaderAccessor {
        NoopURLClassLoaderAccessor(@NotNull URLClassLoader classLoader) {
            super(classLoader);
        }

        @Override
        public void addURL(@NotNull URL url) {
            NoopURLClassLoaderAccessor.throwAccessError(null);
        }
    }

    public static class ClassLoaderAccessException
    extends RuntimeException {
        public ClassLoaderAccessException(String message) {
            super(message);
        }

        public ClassLoaderAccessException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

