/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.quark.classloader;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.bxteam.quark.classloader.IsolatedClassLoader;
import org.jetbrains.annotations.NotNull;

public class IsolatedClassLoaderImpl
extends URLClassLoader
implements IsolatedClassLoader {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicInteger pathCount = new AtomicInteger(0);

    public IsolatedClassLoaderImpl() {
        this(new URL[0]);
    }

    public IsolatedClassLoaderImpl(URL ... urls) {
        super(Objects.requireNonNull(urls, "URLs cannot be null"), IsolatedClassLoaderImpl.getIsolatedParent());
        this.pathCount.set(urls.length);
    }

    public IsolatedClassLoaderImpl(@NotNull ClassLoader parent, URL ... urls) {
        super(Objects.requireNonNull(urls, "URLs cannot be null"), Objects.requireNonNull(parent, "Parent cannot be null"));
        this.pathCount.set(urls.length);
    }

    @NotNull
    private static ClassLoader getIsolatedParent() {
        ClassLoader systemParent = ClassLoader.getSystemClassLoader().getParent();
        return systemParent != null ? systemParent : ClassLoader.getSystemClassLoader();
    }

    @Override
    public synchronized void addURL(@NotNull URL url) {
        this.checkNotClosed();
        super.addURL(Objects.requireNonNull(url, "URL cannot be null"));
        this.pathCount.incrementAndGet();
    }

    @Override
    public void addPath(@NotNull Path path) {
        Objects.requireNonNull(path, "Path cannot be null");
        this.checkNotClosed();
        try {
            this.addURL(path.toUri().toURL());
        }
        catch (MalformedURLException e) {
            throw new IsolatedClassLoader.ClassLoaderException("Invalid path for URL conversion: " + String.valueOf(path), e);
        }
    }

    @Override
    @NotNull
    public Class<?> loadClass(@NotNull String className) throws ClassNotFoundException {
        Objects.requireNonNull(className, "Class name cannot be null");
        this.checkNotClosed();
        return super.loadClass(className);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                super.close();
            }
            catch (IOException e) {
                throw new IsolatedClassLoader.ClassLoaderException("Failed to close class loader", e);
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public int getPathCount() {
        return this.pathCount.get();
    }

    @NotNull
    public URL[] getAllURLs() {
        this.checkNotClosed();
        return this.getURLs();
    }

    private void checkNotClosed() {
        if (this.closed.get()) {
            throw new IsolatedClassLoader.ClassLoaderException("Class loader has been closed");
        }
    }

    public String toString() {
        return "IsolatedClassLoaderImpl{pathCount=" + this.pathCount.get() + ", closed=" + this.closed.get() + ", parent=" + this.getParent().getClass().getSimpleName() + "}";
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

