/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.quark.bukkit;

import java.io.InputStream;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bukkit.plugin.java.JavaPlugin;
import org.bxteam.quark.LibraryManager;
import org.bxteam.quark.classloader.IsolatedClassLoader;
import org.bxteam.quark.classloader.IsolatedClassLoaderImpl;
import org.bxteam.quark.classloader.URLClassLoaderHelper;
import org.bxteam.quark.dependency.Dependency;
import org.bxteam.quark.logger.LogAdapter;
import org.bxteam.quark.logger.adapters.JavaLogAdapter;
import org.bxteam.quark.relocation.Relocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitLibraryManager
extends LibraryManager {
    private final JavaPlugin plugin;
    private final URLClassLoaderHelper classLoaderHelper;

    public BukkitLibraryManager(@NotNull JavaPlugin plugin) {
        this(plugin, "libs");
    }

    public BukkitLibraryManager(@NotNull JavaPlugin plugin, @NotNull String librariesDirectoryName) {
        this(plugin, librariesDirectoryName, new JavaLogAdapter(plugin.getLogger()));
    }

    public BukkitLibraryManager(@NotNull JavaPlugin plugin, @NotNull String librariesDirectoryName, @NotNull LogAdapter logAdapter) {
        super(logAdapter, plugin.getDataFolder().toPath(), librariesDirectoryName);
        this.plugin = Objects.requireNonNull(plugin, "Plugin cannot be null");
        ClassLoader pluginClassLoader = plugin.getClass().getClassLoader();
        if (!(pluginClassLoader instanceof URLClassLoader)) {
            throw new IllegalStateException("Plugin class loader is not a URLClassLoader: " + String.valueOf(pluginClassLoader.getClass()));
        }
        this.classLoaderHelper = new URLClassLoaderHelper((URLClassLoader)pluginClassLoader, this);
        this.logger.debug("Initialized BukkitLibraryManager for plugin: " + plugin.getName());
    }

    @Override
    protected void addToClasspath(@NotNull Path jarPath) {
        Objects.requireNonNull(jarPath, "JAR path cannot be null");
        try {
            this.classLoaderHelper.addToClasspath(jarPath);
        }
        catch (Exception e) {
            throw new LibraryManager.LibraryLoadException("Failed to add JAR to plugin classpath: " + String.valueOf(jarPath), e);
        }
    }

    @Override
    @NotNull
    protected IsolatedClassLoader createIsolatedClassLoader() {
        return new IsolatedClassLoaderImpl();
    }

    @Override
    @Nullable
    protected InputStream getResourceAsStream(@NotNull String resourcePath) {
        Objects.requireNonNull(resourcePath, "Resource path cannot be null");
        return this.plugin.getResource(resourcePath);
    }

    @Override
    public void loadDependency(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        Objects.requireNonNull(groupId, "Group ID cannot be null");
        Objects.requireNonNull(artifactId, "Artifact ID cannot be null");
        Objects.requireNonNull(version, "Version cannot be null");
        this.loadDependency(Dependency.of(groupId, artifactId, version));
    }

    @Override
    public void loadDependency(@NotNull Dependency dependency) {
        Objects.requireNonNull(dependency, "Dependency cannot be null");
        this.loadDependencies(Collections.singletonList(dependency));
    }

    @Override
    public void loadDependencies(@NotNull List<Dependency> dependencies) {
        this.loadDependencies(dependencies, Collections.emptyList());
    }

    @Override
    public void loadDependencies(@NotNull List<Dependency> dependencies, @NotNull List<Relocation> relocations) {
        Objects.requireNonNull(dependencies, "Dependencies cannot be null");
        Objects.requireNonNull(relocations, "Relocations cannot be null");
        super.loadDependencies(dependencies, relocations);
    }

    public void loadDependenciesIsolated(@NotNull IsolatedClassLoader isolatedClassLoader, @NotNull List<Dependency> dependencies, @NotNull List<Relocation> relocations) {
        super.loadDependencies(isolatedClassLoader, dependencies, relocations);
    }

    @NotNull
    public URLClassLoaderHelper getClassLoaderHelper() {
        return this.classLoaderHelper;
    }
}

