/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.ndailyrewards.utils;

import java.awt.Color;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class TextUtils {
    private static final Pattern GRADIENT_PATTERN = Pattern.compile("<(#[A-Fa-f0-9]{6})>(.*?)</(#[A-Fa-f0-9]{6})>");
    private static final Pattern LEGACY_GRADIENT_PATTERN = Pattern.compile("<(&[A-Za-z0-9])>(.*?)</(&[A-Za-z0-9])>");
    private static final Pattern RGB_PATTERN = Pattern.compile("<(#......)>");

    public static String applyColor(String text) {
        String between;
        if (text == null) {
            return "Not found";
        }
        Matcher gradientMatcher = GRADIENT_PATTERN.matcher(text);
        Matcher legacyGradientMatcher = LEGACY_GRADIENT_PATTERN.matcher(text);
        Matcher rgbMatcher = RGB_PATTERN.matcher(text);
        while (gradientMatcher.find()) {
            Color startColor = Color.decode(gradientMatcher.group(1));
            between = gradientMatcher.group(2);
            Color endColor = Color.decode(gradientMatcher.group(3));
            BeforeType[] types = BeforeType.detect(between);
            between = BeforeType.replaceColors(between);
            text = text.replace(gradientMatcher.group(0), TextUtils.rgbGradient(between, startColor, endColor, types));
        }
        while (legacyGradientMatcher.find()) {
            char first = legacyGradientMatcher.group(1).charAt(1);
            between = legacyGradientMatcher.group(2);
            char second = legacyGradientMatcher.group(3).charAt(1);
            ChatColor firstColor = ChatColor.getByChar((char)first);
            ChatColor secondColor = ChatColor.getByChar((char)second);
            BeforeType[] types = BeforeType.detect(between);
            between = BeforeType.replaceColors(between);
            if (firstColor == null) {
                firstColor = ChatColor.WHITE;
            }
            if (secondColor == null) {
                secondColor = ChatColor.WHITE;
            }
            text = text.replace(legacyGradientMatcher.group(0), TextUtils.rgbGradient(between, firstColor.getColor(), secondColor.getColor(), types));
        }
        while (rgbMatcher.find()) {
            ChatColor color = ChatColor.of((Color)Color.decode(rgbMatcher.group(1)));
            text = text.replace(rgbMatcher.group(0), color.toString());
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    private static String rgbGradient(String str, Color from, Color to, BeforeType[] types) {
        double[] red = TextUtils.linear(from.getRed(), to.getRed(), str.length());
        double[] green = TextUtils.linear(from.getGreen(), to.getGreen(), str.length());
        double[] blue = TextUtils.linear(from.getBlue(), to.getBlue(), str.length());
        StringBuilder before = new StringBuilder();
        for (BeforeType type : types) {
            before.append(ChatColor.getByChar((char)type.getCode()));
        }
        StringBuilder builder = new StringBuilder();
        if (str.length() == 1) {
            return String.valueOf(ChatColor.of((Color)to)) + before.toString() + str;
        }
        for (int i = 0; i < str.length(); ++i) {
            builder.append(ChatColor.of((Color)new Color((int)Math.round(red[i]), (int)Math.round(green[i]), (int)Math.round(blue[i])))).append((CharSequence)before).append(str.charAt(i));
        }
        return builder.toString();
    }

    private static double[] linear(double from, double to, int max) {
        double[] res = new double[max];
        for (int i = 0; i < max; ++i) {
            res[i] = from + (double)i * ((to - from) / (double)(max - 1));
        }
        return res;
    }

    public static String applyPlaceholders(Player player, String text) {
        if (player != null && Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            return PlaceholderAPI.setPlaceholders((Player)player, (String)text);
        }
        return text;
    }

    @Generated
    private TextUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum BeforeType {
        MIXED('k'),
        BOLD('l'),
        CROSSED('m'),
        UNDERLINED('n'),
        CURSIVE('o');

        private final char code;

        private BeforeType(char code) {
            this.code = code;
        }

        public char getCode() {
            return this.code;
        }

        public static BeforeType[] detect(@NotNull String text) {
            ArrayList<BeforeType> values = new ArrayList<BeforeType>();
            if (text.contains("&k")) {
                values.add(MIXED);
            }
            if (text.contains("&l")) {
                values.add(BOLD);
            }
            if (text.contains("&m")) {
                values.add(CROSSED);
            }
            if (text.contains("&n")) {
                values.add(UNDERLINED);
            }
            if (text.contains("&o")) {
                values.add(CURSIVE);
            }
            return values.toArray(new BeforeType[0]);
        }

        public static String replaceColors(String text) {
            return text.replaceAll("&[kmno]", "");
        }
    }
}

